/*
 * Decompiled with CFR 0.152.
 */
package act.job.bytecode;

import act.app.App;
import act.inject.param.ParamValueLoaderManager;
import act.inject.param.ParamValueLoaderService;
import act.job.JobContext;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobMethodMetaInfo;
import act.sys.Env;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.util.E;

public class ReflectedJobInvoker<M extends JobMethodMetaInfo>
extends Osgl.F0<Object> {
    private App app;
    private ClassLoader cl;
    private JobClassMetaInfo classInfo;
    private Class<?> jobClass;
    private MethodAccess methodAccess;
    private M methodInfo;
    private int methodIndex;
    protected Method method;
    private List<BeanSpec> providedParams;
    private boolean disabled;
    private ParamValueLoaderService paramValueLoaderService;

    public ReflectedJobInvoker(M handlerMetaInfo, App app) {
        this.cl = app.classLoader();
        this.methodInfo = handlerMetaInfo;
        this.classInfo = ((JobMethodMetaInfo)handlerMetaInfo).classInfo();
        this.app = app;
    }

    private void init() {
        this.disabled = false;
        this.jobClass = $.classForName((String)this.classInfo.className(), (ClassLoader)this.cl);
        this.disabled = this.disabled || !Env.matches(this.jobClass);
        this.method = ((JobMethodMetaInfo)this.methodInfo).method();
        this.disabled = this.disabled || !Env.matches(this.jobClass);
        this.providedParams = ((JobMethodMetaInfo)this.methodInfo).paramTypes();
        ParamValueLoaderManager paramValueLoaderManager = this.app.service(ParamValueLoaderManager.class);
        if (null != paramValueLoaderManager) {
            this.paramValueLoaderService = paramValueLoaderManager.get(JobContext.class);
        }
        if (!Modifier.isStatic(this.method.getModifiers())) {
            Class[] paramTypes = this.paramTypes();
            this.methodAccess = MethodAccess.get(this.jobClass);
            this.methodIndex = this.methodAccess.getIndex(((JobMethodMetaInfo)this.methodInfo).name(), paramTypes);
        } else {
            this.method.setAccessible(true);
        }
    }

    public Object apply() throws NotAppliedException, Osgl.Break {
        if (null == this.jobClass) {
            this.init();
        }
        if (this.disabled) {
            return null;
        }
        Object job = this.jobClassInstance(this.app);
        return this.invoke(job);
    }

    private Class[] paramTypes() {
        List<BeanSpec> paramTypes = ((JobMethodMetaInfo)this.methodInfo).paramTypes();
        int sz = null == paramTypes ? 0 : paramTypes.size();
        Class[] ca = new Class[sz];
        for (int i = 0; i < sz; ++i) {
            BeanSpec spec = ((JobMethodMetaInfo)this.methodInfo).paramTypes().get(i);
            ca[i] = spec.rawType();
        }
        return ca;
    }

    private Object jobClassInstance(App app) {
        return null != this.paramValueLoaderService ? this.paramValueLoaderService.loadHostBean(this.jobClass, JobContext.current()) : app.getInstance(this.jobClass);
    }

    private Object invoke(Object jobClassInstance) {
        Object result;
        Object[] params = this.params(jobClassInstance);
        if (null != this.methodAccess) {
            result = this.methodAccess.invoke(jobClassInstance, this.methodIndex, params);
        } else {
            try {
                result = this.method.invoke(jobClassInstance, params);
            }
            catch (InvocationTargetException e) {
                throw E.unexpected((Throwable)e.getCause());
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
        return result;
    }

    private Object[] params(Object job) {
        if (null != this.paramValueLoaderService) {
            return this.paramValueLoaderService.loadMethodParams(job, this.method, JobContext.current());
        }
        E.illegalStateIf((this.paramTypes().length > 0 ? 1 : 0) != 0, (String)"Cannot invoke job with parameters before app fully started");
        return new Object[0];
    }
}

