/*
 * Decompiled with CFR 0.152.
 */
package act.job.meta;

import act.Destroyable;
import act.app.App;
import act.asm.Type;
import act.job.meta.JobClassMetaInfo;
import act.util.AsmTypes;
import act.util.DestroyableBase;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.util.C;

@ApplicationScoped
public class JobClassMetaInfoManager
extends DestroyableBase {
    private Map<String, JobClassMetaInfo> jobs = C.newMap((Object[])new Object[0]);
    private Map<Type, List<JobClassMetaInfo>> subTypeInfo = C.newMap((Object[])new Object[0]);

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.jobs.values(), ApplicationScoped.class);
        this.jobs.clear();
        for (List<JobClassMetaInfo> l : this.subTypeInfo.values()) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
        }
        this.subTypeInfo.clear();
        super.releaseResources();
    }

    public void registerJobMetaInfo(JobClassMetaInfo metaInfo) {
        List<JobClassMetaInfo> subTypes;
        JobClassMetaInfo superInfo;
        Type superType;
        String className = Type.getObjectType((String)metaInfo.className()).getClassName();
        this.jobs.put(className, metaInfo);
        if (metaInfo.isJob() && !AsmTypes.OBJECT_TYPE.equals((Object)(superType = metaInfo.superType())) && null == (superInfo = this.jobMetaInfo(superType.getClassName()))) {
            C.List subTypes2 = this.subTypeInfo.get(superType);
            if (null == subTypes2) {
                subTypes2 = C.newList();
            }
            subTypes2.add(metaInfo);
        }
        if (null != (subTypes = this.subTypeInfo.get(metaInfo.type()))) {
            this.subTypeInfo.remove(metaInfo.type());
        }
        App.logger.trace("Job meta info registered for: %s", new Object[]{className});
    }

    public JobClassMetaInfo jobMetaInfo(String className) {
        return this.jobs.get(className);
    }
}

