/*
 * Decompiled with CFR 0.152.
 */
package act.mail;

import act.app.ActionContext;
import act.mail.MailerContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface Mailer {
    public String value() default "default";

    public static class Util {
        protected static final Logger logger = L.get(Mailer.class);
        private static final ThreadLocal<SimpleContext> _ctx = new ThreadLocal<SimpleContext>(){

            @Override
            protected SimpleContext initialValue() {
                return new SimpleContext();
            }
        };

        public static Future<Boolean> send(Object ... args) {
            throw E.unsupport((String)"to be enhanced", (Object[])new Object[0]);
        }

        public static MailerContext mailer() {
            throw E.unsupport((String)"to be enhanced", (Object[])new Object[0]);
        }

        public static void from(String from) {
            Util.ctx().from = from;
        }

        public static void to(List<String> recipients) {
            Util.ctx().to = S.join((String)",", recipients);
        }

        public static void to(String ... recipients) {
            Util.ctx().to = S.join((String)",", (String[])recipients);
        }

        public static void cc(String ... cc) {
            Util.ctx().cc = S.join((String)",", (String[])cc);
        }

        public static void bcc(String ... bcc) {
            Util.ctx().bcc = S.join((String)",", (String[])bcc);
        }

        public static void subject(String subject, Object ... args) {
            Util.ctx().subject = subject;
            Util.ctx().subjectArgs = args;
        }

        private static SimpleContext ctx() {
            return _ctx.get();
        }

        public static Future<Boolean> doSendWithoutLoadThreadLocal(final MailerContext context) {
            return context.app().jobManager().now(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return context.send();
                }
            });
        }

        public static Future<Boolean> doSend(final MailerContext context) {
            Util.tryLoadLocale(context);
            SimpleContext ctx = _ctx.get();
            if (null != ctx) {
                if (S.notBlank((String)ctx.from)) {
                    context.from(ctx.from);
                }
                if (S.notBlank((String)ctx.to)) {
                    context.to(ctx.to);
                }
                if (S.notBlank((String)ctx.cc)) {
                    context.cc(ctx.cc);
                }
                if (S.notBlank((String)ctx.bcc)) {
                    context.bcc(ctx.bcc);
                }
                if (S.notBlank((String)ctx.subject)) {
                    context.subject(ctx.subject, ctx.subjectArgs);
                }
                _ctx.remove();
            }
            return context.app().jobManager().now(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return context.send();
                }
            });
        }

        private static void tryLoadLocale(MailerContext context) {
            if (!context.config().i18nEnabled() || context.locale() != null) {
                return;
            }
            for (Map.Entry<String, Object> entry : context.renderArgs().entrySet()) {
                Object val = entry.getValue();
                if (!(val instanceof ActionContext)) continue;
                context.locale(((ActionContext)val).locale());
                return;
            }
            context.locale(context.config().locale());
        }

        private static class SimpleContext {
            String from;
            String to;
            String cc;
            String bcc;
            String subject;
            Object[] subjectArgs;

            private SimpleContext() {
            }
        }
    }
}

