/*
 * Decompiled with CFR 0.152.
 */
package act.mail;

import act.app.App;
import act.app.AppHolderBase;
import act.mail.MailerContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.osgl.exception.ConfigurationException;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class MailerConfig
extends AppHolderBase {
    public static final Logger logger = LogManager.get(MailerConfig.class);
    public static final String FROM = "from";
    public static final String CONTENT_TYPE = "content_type";
    public static final String LOCALE = "locale";
    public static final String SUBJECT = "subject";
    public static final String TO = "to";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String SMTP_HOST = "smtp.host";
    public static final String SMTP_PORT = "smtp.port";
    public static final String SMTP_TLS = "smtp.tls";
    public static final String SMTP_SSL = "smtp.ssl";
    public static final String SMTP_USERNAME = "smtp.username";
    public static final String SMTP_PASSWORD = "smtp.password";
    private String id;
    private boolean isDefault;
    private boolean mock;
    private InternetAddress from;
    private H.Format contentType;
    private Locale locale;
    private String subject;
    private String host;
    private String port;
    private boolean useTls;
    private boolean useSsl;
    private String username;
    private String password;
    private List<InternetAddress> toList;
    private List<InternetAddress> ccList;
    private List<InternetAddress> bccList;
    private volatile Session session;

    public MailerConfig(String id, Map<String, String> properties, App app) {
        super(app);
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"mailer config id expected");
        this.id = id;
        this.isDefault = "default".equals(id);
        this.from = this.getFromConfig(properties);
        this.contentType = this.getContentTypeConfig(properties);
        this.locale = this.getLocaleConfig(properties);
        this.subject = this.getProperty(SUBJECT, properties);
        this.host = this.getProperty(SMTP_HOST, properties);
        if ("gmail".equals(this.host)) {
            this.host = "smtp.gmail.com";
        }
        this.username = this.getProperty(SMTP_USERNAME, properties);
        if (null == this.host) {
            if (S.notBlank((String)this.username) && this.username.endsWith("gmail.com")) {
                this.host = "smtp.gmail.com";
            } else {
                logger.warn("smtp host configuration not found, will use mock smtp to send email");
                this.mock = true;
            }
        }
        if (!this.mock) {
            this.useTls = this.getBooleanConfig(SMTP_TLS, properties) || S.eq((String)"smtp.gmail.com", (String)this.host);
            this.useSsl = !this.useTls && this.getBooleanConfig(SMTP_SSL, properties);
            this.port = this.getPortConfig(properties);
            this.password = this.getProperty(SMTP_PASSWORD, properties);
            if (null == this.username || null == this.password) {
                logger.warn("Either smtp.username or smtp.password is not configured for mailer[%s]", new Object[]{id});
            }
        }
        this.toList = this.getEmailListConfig(TO, properties);
        this.ccList = this.getEmailListConfig(CC, properties);
        this.bccList = this.getEmailListConfig(BCC, properties);
    }

    private String getProperty(String key, Map<String, String> properties) {
        String key0 = key;
        String val = properties.get(key = S.concat((String)"mailer.", (String)this.id, (String)".", (String)key));
        if (null != val) {
            return val;
        }
        String key2 = "act." + key;
        val = properties.get(key2);
        if (null != val) {
            return val;
        }
        if (this.isDefault) {
            key = S.concat((String)"mailer.", (String)key0);
            val = properties.get(key);
            if (null != val) {
                return val;
            }
            return properties.get(S.concat((String)"act.", (String)key));
        }
        return null;
    }

    private List<InternetAddress> getEmailListConfig(String key, Map<String, String> properties) {
        String s = this.getProperty(key, properties);
        if (S.blank((String)s)) {
            return C.list();
        }
        C.List l = C.newList();
        return MailerContext.canonicalRecipients((List<InternetAddress>)l, s);
    }

    private String getPortConfig(Map<String, String> properties) {
        String port = this.getProperty(SMTP_PORT, properties);
        if (null == port) {
            port = !this.useSsl && !this.useTls ? "25" : (this.useSsl ? "465" : "587");
            logger.warn("No smtp.port found for mailer[%s] configuration will use the default number: ", new Object[]{this.id, port});
        } else {
            try {
                Integer.parseInt(port);
            }
            catch (Exception e) {
                throw E.invalidConfiguration((String)"Invalid port configuration for mailer[%]: %s", (Object[])new Object[]{this.id, port});
            }
        }
        return port;
    }

    private boolean getBooleanConfig(String key, Map<String, String> properties) {
        String s = this.getProperty(key, properties);
        return null != s && Boolean.parseBoolean(s);
    }

    private Locale getLocaleConfig(Map<String, String> properties) {
        String s = this.getProperty(LOCALE, properties);
        if (null == s) {
            return this.app().config().locale();
        }
        String localeString = s.trim();
        if (localeString.toLowerCase().equals("default")) {
            return this.app().config().locale();
        }
        int languageIndex = localeString.indexOf(95);
        String language = null;
        if (languageIndex == -1) {
            return new Locale(localeString, "");
        }
        language = localeString.substring(0, languageIndex);
        int countryIndex = localeString.indexOf(95, languageIndex + 1);
        if (countryIndex == -1) {
            String country = localeString.substring(languageIndex + 1);
            return new Locale(language, country);
        }
        String country = localeString.substring(languageIndex + 1, countryIndex);
        String variant = localeString.substring(countryIndex + 1);
        return new Locale(language, country, variant);
    }

    private H.Format getContentTypeConfig(Map<String, String> properties) {
        String s = this.getProperty(CONTENT_TYPE, properties);
        if (null == s) {
            return null;
        }
        try {
            H.Format fmt = H.Format.valueOf((String)s);
            if (H.Format.HTML == fmt || H.Format.TXT == fmt) {
                return fmt;
            }
            throw E.invalidConfiguration((String)"Content type not supported by mailer: %s", (Object[])new Object[]{fmt});
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw E.invalidConfiguration((String)"Invalid mailer config content type: %s", (Object[])new Object[]{s});
        }
    }

    private InternetAddress getFromConfig(Map<String, String> properties) {
        String s = this.getProperty(FROM, properties);
        if (null == s) {
            return null;
        }
        try {
            InternetAddress[] ia = InternetAddress.parse((String)s);
            if (null == ia || ia.length == 0) {
                return null;
            }
            return ia[0];
        }
        catch (AddressException e) {
            throw E.invalidConfiguration((Throwable)e, (String)"invalid mailer from address: %s", (Object[])new Object[]{s});
        }
    }

    @Override
    protected void releaseResources() {
        if (null != this.session) {
            this.session = null;
        }
    }

    public String id() {
        return this.id;
    }

    public String subject() {
        return this.subject;
    }

    public H.Format contentType() {
        return this.contentType;
    }

    public InternetAddress from() {
        return this.from;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Locale locale() {
        return null != this.locale ? this.locale : this.app().config().locale();
    }

    public List<InternetAddress> to() {
        return this.toList;
    }

    public List<InternetAddress> ccList() {
        return this.ccList;
    }

    public List<InternetAddress> bccList() {
        return this.bccList;
    }

    public boolean mock() {
        return this.mock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session session() {
        if (null == this.session) {
            MailerConfig mailerConfig = this;
            synchronized (mailerConfig) {
                if (null == this.session) {
                    this.session = this.createSession();
                }
            }
        }
        return this.session;
    }

    private Session createSession() {
        Properties p = new Properties();
        if (this.mock()) {
            p.setProperty("mail.smtp.host", "unknown");
            p.setProperty("mail.smtp.port", "465");
        } else {
            p.setProperty("mail.smtp.host", this.host);
            p.setProperty("mail.smtp.port", this.port);
        }
        if (null != this.username && null != this.password) {
            if (this.useTls) {
                p.put("mail.smtp.starttls.enable", "true");
            } else if (this.useSsl) {
                p.put("mail.smtp.socketFactory.port", this.port);
                p.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            p.setProperty("mail.smtp.auth", "true");
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailerConfig.this.username, MailerConfig.this.password);
                }
            };
            return Session.getInstance((Properties)p, (Authenticator)auth);
        }
        return Session.getInstance((Properties)p);
    }
}

