/*
 * Decompiled with CFR 0.152.
 */
package act.mail;

import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.conf.AppConfig;
import act.mail.MailerConfig;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.util.C;

@ApplicationScoped
public class MailerConfigManager
extends AppServiceBase<MailerConfigManager> {
    public static final String KEY_MAILER = "mailer";
    private C.Map<String, MailerConfig> configMap = C.newMap((Object[])new Object[0]);

    @Inject
    public MailerConfigManager(App app) {
        super(app);
        this.loadConfig(app.config());
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.configMap.values(), ApplicationScoped.class);
        this.configMap.clear();
    }

    public MailerConfig config(String id) {
        return (MailerConfig)this.configMap.get((Object)id);
    }

    private void loadConfig(AppConfig config) {
        String s;
        String[] sa;
        Object o = config.get(KEY_MAILER);
        if (null == o) {
            o = config.get("act.mailer");
        }
        Map map = config.rawConfiguration();
        if (null != o && (sa = (s = o.toString()).split("[\\s,;:]+")).length > 0) {
            for (String id : sa) {
                this.configMap.put((Object)id, (Object)new MailerConfig(id, map, this.app()));
            }
        }
        this.configMap.put((Object)"default", (Object)new MailerConfig("default", map, this.app()));
    }
}

