/*
 * Decompiled with CFR 0.152.
 */
package act.mail.bytecode;

import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.FieldVisitor;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.asm.signature.SignatureReader;
import act.asm.signature.SignatureVisitor;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.ParamAnnoInfoTrait;
import act.mail.Mailer;
import act.mail.meta.MailerClassMetaInfo;
import act.mail.meta.MailerClassMetaInfoManager;
import act.mail.meta.SenderMethodMetaInfo;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.GeneralAnnoInfo;
import java.util.List;
import java.util.Map;
import org.osgl.Osgl;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class MailerByteCodeScanner
extends AppByteCodeScannerBase {
    private static final Logger logger = L.get(MailerByteCodeScanner.class);
    private MailerClassMetaInfo classInfo;
    private volatile MailerClassMetaInfoManager classInfoBase;

    @Override
    protected boolean shouldScan(String className) {
        this.classInfo = new MailerClassMetaInfo();
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        this.classInfoBase().registerMailerMetaInfo(this.classInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailerClassMetaInfoManager classInfoBase() {
        if (null == this.classInfoBase) {
            MailerByteCodeScanner mailerByteCodeScanner = this;
            synchronized (mailerByteCodeScanner) {
                if (null == this.classInfoBase) {
                    this.classInfoBase = this.app().classLoader().mailerClassMetaInfoManager();
                }
            }
        }
        return this.classInfoBase;
    }

    public static boolean isMailerAnno(String desc) {
        return Type.getType(Mailer.class).getDescriptor().equals(desc);
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            logger.trace("Scanning %s", new Object[]{name});
            MailerByteCodeScanner.this.classInfo.className(name);
            if (_ByteCodeVisitor.isAbstract(access)) {
                MailerByteCodeScanner.this.classInfo.setAbstract();
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (MailerByteCodeScanner.this.classInfo.isMailer() && AsmTypes.ACTION_CONTEXT_DESC.equals(desc)) {
                MailerByteCodeScanner.this.classInfo.ctxField(name, _ByteCodeVisitor.isPrivate(access));
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (MailerByteCodeScanner.isMailerAnno(desc)) {
                MailerByteCodeScanner.this.classInfo.isMailer(true);
                return new MailerAnnotationVisitor(av);
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!MailerByteCodeScanner.this.classInfo.isMailer() || !this.isEligibleMethod(access, name, desc)) {
                return mv;
            }
            return new SenderMethodVisitor(mv, access, name, desc, signature, exceptions);
        }

        private boolean isEligibleMethod(int access, String name, String desc) {
            return _ByteCodeVisitor.isPublic(access) && !_ByteCodeVisitor.isAbstract(access) && !_ByteCodeVisitor.isConstructor(name) && name.startsWith("send");
        }

        private class SenderMethodVisitor
        extends MethodVisitor
        implements Opcodes {
            private String methodName;
            private int access;
            private String desc;
            private String signature;
            private boolean requireScan;
            private SenderMethodMetaInfo methodInfo;
            private Map<Integer, List<ParamAnnoInfoTrait>> paramAnnoInfoList;
            private Map<Integer, List<GeneralAnnoInfo>> genericParamAnnoInfoList;

            SenderMethodVisitor(MethodVisitor mv, int access, String methodName, String desc, String signature, String[] exceptions) {
                super(327680, mv);
                this.paramAnnoInfoList = C.newMap((Object[])new Object[0]);
                this.genericParamAnnoInfoList = C.newMap((Object[])new Object[0]);
                this.access = access;
                this.methodName = methodName;
                this.desc = desc;
                this.signature = signature;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (MailerByteCodeScanner.isMailerAnno(desc)) {
                    if (null == this.methodInfo) {
                        this.methodInfo = new SenderMethodMetaInfo(MailerByteCodeScanner.this.classInfo);
                        MailerByteCodeScanner.this.classInfo.addSender(this.methodInfo);
                    }
                    return new SenderAnnotationVisitor(av);
                }
                return av;
            }

            public void visitEnd() {
                if (null == this.methodInfo) {
                    this.methodInfo = new SenderMethodMetaInfo(MailerByteCodeScanner.this.classInfo);
                    MailerByteCodeScanner.this.classInfo.addSender(this.methodInfo);
                }
                final SenderMethodMetaInfo info = this.methodInfo;
                info.name(this.methodName);
                boolean isStatic = AsmTypes.isStatic(this.access);
                if (isStatic) {
                    info.invokeStaticMethod();
                } else {
                    info.invokeInstanceMethod();
                }
                info.returnType(Type.getReturnType((String)this.desc));
                Type[] argTypes = Type.getArgumentTypes((String)this.desc);
                boolean ctxByParam = false;
                for (int i = 0; i < argTypes.length; ++i) {
                    List<GeneralAnnoInfo> list;
                    Type type = argTypes[i];
                    HandlerParamMetaInfo param = new HandlerParamMetaInfo().type(type);
                    List<ParamAnnoInfoTrait> paraAnnoList = this.paramAnnoInfoList.get(i);
                    if (null != paraAnnoList) {
                        for (ParamAnnoInfoTrait trait : paraAnnoList) {
                            trait.attachTo(param);
                        }
                    }
                    if (null != (list = this.genericParamAnnoInfoList.get(i))) {
                        param.addGeneralAnnotations(list);
                    }
                    info.addParam(param);
                }
                if (null != this.signature) {
                    SignatureReader sr = new SignatureReader(this.signature);
                    final Osgl.Var id = new Osgl.Var((Object)-1);
                    sr.accept(new SignatureVisitor(327680){
                        boolean startParsing;

                        public SignatureVisitor visitParameterType() {
                            id.set((Object)((Integer)id.get() + 1));
                            return this;
                        }

                        public SignatureVisitor visitTypeArgument(char wildcard) {
                            if (wildcard == '=') {
                                this.startParsing = true;
                            }
                            return this;
                        }

                        public void visitClassType(String name) {
                            if (this.startParsing) {
                                Type type = Type.getObjectType((String)name);
                                int n = (Integer)id.get();
                                if (n < 0) {
                                    info.returnComponentType(type);
                                } else {
                                    info.param(n).componentType(type);
                                }
                            }
                            this.startParsing = false;
                        }
                    });
                }
                super.visitEnd();
            }

            private class SenderAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                public SenderAnnotationVisitor(AnnotationVisitor av) {
                    super(327680, av);
                }

                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        SenderMethodVisitor.this.methodInfo.configId(value.toString());
                    }
                }
            }
        }

        private class MailerAnnotationVisitor
        extends AnnotationVisitor {
            MailerAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    MailerByteCodeScanner.this.classInfo.configId(value.toString());
                }
            }
        }
    }
}

