/*
 * Decompiled with CFR 0.152.
 */
package act.mail.bytecode;

import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.asm.tree.AbstractInsnNode;
import act.asm.tree.InsnList;
import act.asm.tree.InsnNode;
import act.asm.tree.LabelNode;
import act.asm.tree.LdcInsnNode;
import act.asm.tree.MethodInsnNode;
import act.asm.tree.MethodNode;
import act.asm.tree.TypeInsnNode;
import act.asm.tree.VarInsnNode;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.LocalVariableMetaInfo;
import act.mail.MailerContext;
import act.mail.meta.SenderMethodMetaInfo;
import act.util.AsmTypes;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class SenderEnhancer
extends MethodVisitor
implements Opcodes {
    private static final Logger logger = L.get(SenderEnhancer.class);
    private SenderMethodMetaInfo info;
    private MethodVisitor next;
    private int paramIdShift = 0;
    private static final String GET_MAILER_CTX_DESC = "()" + AsmTypes.MAILER_CONTEXT_DESC;
    private static final String RENDER_NM = "renderArg";
    private static final String RENDER_DESC = AsmTypes.methodDesc(MailerContext.class, String.class, Object.class);
    private static final String TEMPLATE_PATH_NM = "templatePath";
    private static final String SENDER_PATH_NM = "senderPath";
    private static final String TEMPLATE_PATH_DESC = AsmTypes.methodDesc(MailerContext.class, String.class);
    private static final String SENDER_PATH_DESC = AsmTypes.methodDesc(MailerContext.class, String.class, String.class);
    private static final String RENDER_ARG_NAMES_NM = "__appRenderArgNames";
    private static final String RENDER_ARG_NAMES_DESC = AsmTypes.methodDesc(MailerContext.class, String.class);

    public SenderEnhancer(MethodVisitor mv, SenderMethodMetaInfo meta, int access, String name, String desc, String signature, String[] exceptions) {
        super(327680, (MethodVisitor)new MethodNode(access, name, desc, signature, exceptions));
        this.info = meta;
        this.next = mv;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (!"this".equals(name)) {
            int paramId = index;
            if (!this.info.isStatic()) {
                --paramId;
            }
            if ((paramId -= this.paramIdShift) < this.info.paramCount()) {
                HandlerParamMetaInfo param = this.info.param(paramId);
                param.name(name);
                if (Type.getType(Long.TYPE).equals((Object)param.type()) || Type.getType(Double.TYPE).equals((Object)param.type())) {
                    ++this.paramIdShift;
                }
            }
            LocalVariableMetaInfo local = new LocalVariableMetaInfo(index, name, desc, start, end);
            this.info.addLocal(local);
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitEnd() {
        MethodNode mn = (MethodNode)this.mv;
        this.transform(mn);
        mn.accept(this.next);
        super.visitEnd();
    }

    private void transform(MethodNode mn) {
        new Transformer(mn, this.info).doIt();
    }

    private static class Transformer {
        MethodNode mn;
        InsnList instructions;
        private SenderMethodMetaInfo meta;
        List<Label> lblList = C.newSizedList((int)20);
        private static final int _I = 73;
        private static final int _Z = 90;
        private static final int _S = 83;
        private static final int _B = 66;
        private static final int _C = 67;

        Transformer(MethodNode mn, SenderMethodMetaInfo meta) {
            this.mn = mn;
            this.meta = meta;
            this.instructions = mn.instructions;
        }

        void doIt() {
            ListIterator itr = this.instructions.iterator();
            Segment cur = null;
            while (itr.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)itr.next();
                if (insn.getType() == 8) {
                    cur = new Segment(((LabelNode)insn).getLabel(), this.meta, this.instructions, itr, this);
                    continue;
                }
                if (null == cur || !cur.handle(insn)) continue;
                cur = null;
            }
        }

        private static class LoadInsnInfo {
            LoadInsn insn;
            int index;

            LoadInsnInfo(LoadInsn insn, int index) {
                this.insn = insn;
                this.index = index;
            }

            void appendTo(InsnList list, Segment segment, S.Buffer paramNames) {
                LocalVariableMetaInfo var = this.var(segment);
                if (null == var) {
                    return;
                }
                LdcInsnNode ldc = new LdcInsnNode((Object)var.name());
                list.add((AbstractInsnNode)ldc);
                this.insn.appendTo(list, this.index, var.type());
                MethodInsnNode invokeRenderArg = new MethodInsnNode(182, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, SenderEnhancer.RENDER_NM, RENDER_DESC, false);
                list.add((AbstractInsnNode)invokeRenderArg);
                if (paramNames.length() != 0) {
                    paramNames.append(',');
                }
                paramNames.append(var.name());
            }

            LocalVariableMetaInfo var(Segment segment) {
                Label lbl = segment.startLabel;
                int pos = -1;
                List<Label> lblList = segment.trans.lblList;
                while (null != lbl) {
                    LocalVariableMetaInfo var = segment.meta.localVariable(this.index, lbl);
                    if (null != var) {
                        return var;
                    }
                    if (-1 == pos && (pos = lblList.indexOf(lbl)) <= 0) {
                        return null;
                    }
                    lbl = lblList.get(--pos);
                }
                return null;
            }

            public String toString() {
                return S.fmt((String)"%sLoad %s", (Object[])new Object[]{this.insn, this.index});
            }
        }

        private static enum LoadInsn {
            I(21){

                @Override
                void appendTo(InsnList list, int varIndex, String type) {
                    String desc;
                    String owner;
                    super.appendTo(list, varIndex, type);
                    switch (type.hashCode()) {
                        case 73: {
                            owner = "java/lang/Integer";
                            desc = "(I)Ljava/lang/Integer;";
                            break;
                        }
                        case 90: {
                            owner = "java/lang/Boolean";
                            desc = "(Z)Ljava/lang/Boolean;";
                            break;
                        }
                        case 83: {
                            owner = "java/lang/Short";
                            desc = "(S)Ljava/lang/Short";
                            break;
                        }
                        case 66: {
                            owner = "java/lang/Byte";
                            desc = "(B)Ljava/lang/Byte;";
                            break;
                        }
                        case 67: {
                            owner = "java/lang/Character";
                            desc = "(C)Ljava/lang/Character;";
                            break;
                        }
                        default: {
                            throw E.unexpected((String)"int var type not recognized: %s", (Object[])new Object[]{type});
                        }
                    }
                    MethodInsnNode method = new MethodInsnNode(184, owner, "valueOf", desc, false);
                    list.add((AbstractInsnNode)method);
                }
            }
            ,
            L(22){

                @Override
                void appendTo(InsnList list, int varIndex, String type) {
                    super.appendTo(list, varIndex, type);
                    MethodInsnNode method = new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    list.add((AbstractInsnNode)method);
                }
            }
            ,
            F(23){

                @Override
                void appendTo(InsnList list, int varIndex, String type) {
                    super.appendTo(list, varIndex, type);
                    MethodInsnNode method = new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    list.add((AbstractInsnNode)method);
                }
            }
            ,
            D(24){

                @Override
                void appendTo(InsnList list, int varIndex, String type) {
                    super.appendTo(list, varIndex, type);
                    MethodInsnNode method = new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    list.add((AbstractInsnNode)method);
                }
            }
            ,
            A(25),
            Store(-1){

                @Override
                void appendTo(InsnList list, int varIndex, String type) {
                    throw E.unsupport();
                }
            };

            private int opcode;

            private LoadInsn(int opcode) {
                this.opcode = opcode;
            }

            static LoadInsn of(int opcode) {
                switch (opcode) {
                    case 21: {
                        return I;
                    }
                    case 22: {
                        return L;
                    }
                    case 23: {
                        return F;
                    }
                    case 24: {
                        return D;
                    }
                    case 25: {
                        return A;
                    }
                }
                return Store;
            }

            boolean isStoreInsn() {
                return this == Store;
            }

            void appendTo(InsnList list, int varIndex, String type) {
                VarInsnNode load = new VarInsnNode(this.opcode, varIndex);
                list.add((AbstractInsnNode)load);
            }
        }

        private static class InvocationHandler
        extends InstructionHandler {
            InvocationHandler(Segment segment, SenderMethodMetaInfo meta) {
                super(segment, meta);
            }

            @Override
            protected boolean handle(AbstractInsnNode node) {
                MethodInsnNode n = (MethodInsnNode)node;
                Type type = Type.getMethodType((String)n.desc);
                Type retType = type.getReturnType();
                if (MailerContext.class.getName().equals(retType.getClassName())) {
                    return this.injectCreatingMailerContextCode((AbstractInsnNode)n);
                }
                if (Future.class.getName().equals(retType.getClassName()) && "send".equals(n.name)) {
                    return this.injectRenderArgSetCode((AbstractInsnNode)n);
                }
                return false;
            }

            private boolean injectCreatingMailerContextCode(AbstractInsnNode insnNode) {
                AbstractInsnNode node = insnNode.getNext();
                InsnList list = new InsnList();
                if (node instanceof VarInsnNode) {
                    VarInsnNode varNode = (VarInsnNode)node;
                    if (varNode.getOpcode() == 58) {
                        this.meta.appCtxLocalVariableTableIndex(varNode.var);
                        list.add((AbstractInsnNode)new TypeInsnNode(187, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME));
                        list.add((AbstractInsnNode)new InsnNode(89));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, AsmTypes.APP_INTERNAL_NAME, "instance", "()" + AsmTypes.APP_DESC, false));
                        String confId = this.meta.configId();
                        if (null == confId) {
                            confId = "default";
                        }
                        list.add((AbstractInsnNode)new LdcInsnNode((Object)confId));
                        list.add((AbstractInsnNode)new MethodInsnNode(183, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, "<init>", "(Lact/app/App;Ljava/lang/String;)V", false));
                        this.segment.instructions.insertBefore(node, list);
                        this.segment.instructions.remove(insnNode);
                        return true;
                    }
                    return false;
                }
                list.add((AbstractInsnNode)new TypeInsnNode(187, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME));
                list.add((AbstractInsnNode)new InsnNode(89));
                list.add((AbstractInsnNode)new MethodInsnNode(184, AsmTypes.APP_INTERNAL_NAME, "instance", "()" + AsmTypes.APP_DESC, false));
                String confId = this.meta.configId();
                if (null == confId) {
                    confId = "default";
                }
                list.add((AbstractInsnNode)new LdcInsnNode((Object)confId));
                list.add((AbstractInsnNode)new MethodInsnNode(183, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, "<init>", "(Lact/app/App;Ljava/lang/String;)V", false));
                this.segment.instructions.insertBefore(node, list);
                this.segment.instructions.remove(insnNode);
                node = node.getNext();
                while (node.getOpcode() != 87) {
                    node = node.getNext();
                }
                int maxLocal = this.segment.trans.mn.maxLocals++;
                this.segment.instructions.insertBefore(node, (AbstractInsnNode)new VarInsnNode(58, maxLocal));
                this.segment.instructions.remove(node);
                this.meta.appCtxLocalVariableTableIndex(maxLocal);
                return true;
            }

            private boolean injectRenderArgSetCode(AbstractInsnNode invokeNode) {
                String method;
                AbstractInsnNode node;
                if (!this.segment.meta.hasLocalVariableTable()) {
                    logger.warn("local variable table info not found. AppContext render args will not be automatically populated");
                }
                C.List loadInsnInfoList = C.newList();
                String templatePath = null;
                for (node = invokeNode.getPrevious(); null != node; node = node.getPrevious()) {
                    int type = node.getType();
                    boolean breakWhile = false;
                    switch (type) {
                        case 8: 
                        case 14: {
                            node = node.getNext();
                            breakWhile = true;
                            break;
                        }
                        case 2: {
                            LoadInsn insn;
                            VarInsnNode n = (VarInsnNode)node;
                            if (0 == n.var && !this.segment.meta.isStatic() || (insn = LoadInsn.of(n.getOpcode())).isStoreInsn()) break;
                            LoadInsnInfo info = new LoadInsnInfo(insn, n.var);
                            loadInsnInfoList.add(info);
                            break;
                        }
                        case 9: {
                            LdcInsnNode ldc = (LdcInsnNode)node;
                            if (null != templatePath) {
                                logger.warn("Cannot have more than one template path parameter in the render call. Template path[%s] ignored", new Object[]{templatePath});
                                break;
                            }
                            if (!(ldc.cst instanceof String)) {
                                logger.warn("Template path must be strictly String type. Found: %s", new Object[]{ldc.cst});
                                break;
                            }
                            templatePath = ldc.cst.toString();
                        }
                    }
                    if (breakWhile) break;
                }
                InsnList list = new InsnList();
                int len = loadInsnInfoList.size();
                int ctxId = this.meta.appCtxLocalVariableTableIndex();
                if (ctxId < 0) {
                    list.add((AbstractInsnNode)new TypeInsnNode(187, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME));
                    list.add((AbstractInsnNode)new InsnNode(89));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, AsmTypes.APP_INTERNAL_NAME, "instance", "()" + AsmTypes.APP_DESC, false));
                    String confId = this.meta.configId();
                    if (null == confId) {
                        confId = "default";
                    }
                    list.add((AbstractInsnNode)new LdcInsnNode((Object)confId));
                    list.add((AbstractInsnNode)new MethodInsnNode(183, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, "<init>", "(Lact/app/App;Ljava/lang/String;)V", false));
                    int maxLocal = this.segment.trans.mn.maxLocals++;
                    list.add((AbstractInsnNode)new VarInsnNode(58, maxLocal));
                    ctxId = maxLocal;
                }
                list.add((AbstractInsnNode)new VarInsnNode(25, ctxId));
                S.Buffer sb = S.newBuffer();
                for (int i = 0; i < len; ++i) {
                    LoadInsnInfo info = (LoadInsnInfo)loadInsnInfoList.get(i);
                    info.appendTo(list, this.segment, sb);
                }
                LdcInsnNode ldc = new LdcInsnNode((Object)sb.toString());
                list.add((AbstractInsnNode)ldc);
                MethodInsnNode invokeRenderArg = new MethodInsnNode(182, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, SenderEnhancer.RENDER_ARG_NAMES_NM, RENDER_ARG_NAMES_DESC, false);
                list.add((AbstractInsnNode)invokeRenderArg);
                if (null != templatePath) {
                    LdcInsnNode insnNode = new LdcInsnNode((Object)templatePath);
                    list.add((AbstractInsnNode)insnNode);
                    MethodInsnNode invokeTemplatePath = new MethodInsnNode(182, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, SenderEnhancer.TEMPLATE_PATH_NM, TEMPLATE_PATH_DESC, false);
                    list.add((AbstractInsnNode)invokeTemplatePath);
                } else {
                    String className = this.meta.classInfo().className();
                    method = this.meta.name();
                    list.add((AbstractInsnNode)new LdcInsnNode((Object)className));
                    list.add((AbstractInsnNode)new LdcInsnNode((Object)method));
                    list.add((AbstractInsnNode)new MethodInsnNode(182, AsmTypes.MAILER_CONTEXT_INTERNAL_NAME, SenderEnhancer.SENDER_PATH_NM, SENDER_PATH_DESC, false));
                }
                InsnNode pop = new InsnNode(87);
                list.add((AbstractInsnNode)pop);
                list.add((AbstractInsnNode)new VarInsnNode(25, ctxId));
                method = this.meta.appCtxLocalVariableTableIndex() < 0 ? "doSend" : "doSendWithoutLoadThreadLocal";
                MethodInsnNode realSend = new MethodInsnNode(184, "act/mail/Mailer$Util", method, "(Lact/mail/MailerContext;)Ljava/util/concurrent/Future;", false);
                list.add((AbstractInsnNode)realSend);
                this.segment.instructions.insertBefore(node, list);
                while (node != invokeNode) {
                    AbstractInsnNode n0 = node.getNext();
                    this.segment.instructions.remove(node);
                    node = n0;
                }
                this.segment.instructions.remove(invokeNode);
                return true;
            }
        }

        private static class Segment {
            Label startLabel;
            InsnList instructions;
            SenderMethodMetaInfo meta;
            ListIterator<AbstractInsnNode> itr;
            Transformer trans;
            private Map<Integer, InstructionHandler> handlers;

            Segment(Label start, SenderMethodMetaInfo meta, InsnList instructions, ListIterator<AbstractInsnNode> itr, Transformer trans) {
                E.NPE((Object)meta);
                this.startLabel = start;
                this.meta = meta;
                this.instructions = instructions;
                this.itr = itr;
                this.trans = trans;
                this.handlers = C.map((Object[])new Object[]{5, new InvocationHandler(this, meta)});
                trans.lblList.add(start);
            }

            protected boolean handle(AbstractInsnNode node) {
                InstructionHandler handler = this.handlers.get(node.getType());
                if (null != handler) {
                    return handler.handle(node);
                }
                return false;
            }
        }

        private static abstract class InstructionHandler {
            Segment segment;
            SenderMethodMetaInfo meta;

            InstructionHandler(Segment segment, SenderMethodMetaInfo meta) {
                this.segment = segment;
                this.meta = meta;
            }

            protected abstract boolean handle(AbstractInsnNode var1);

            protected void refreshIteratorNext() {
                this.segment.itr.previous();
                this.segment.itr.next();
            }
        }
    }
}

