/*
 * Decompiled with CFR 0.152.
 */
package act.mail.meta;

import act.asm.Label;
import act.asm.Type;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.LocalVariableMetaInfo;
import act.mail.meta.MailerClassMetaInfo;
import act.sys.meta.InvokeType;
import act.sys.meta.ReturnTypeInfo;
import act.util.AsmTypes;
import act.util.DestroyableBase;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class SenderMethodMetaInfo
extends DestroyableBase {
    private String name;
    private String configId;
    private InvokeType invokeType;
    private MailerClassMetaInfo clsInfo;
    private C.List<HandlerParamMetaInfo> params = C.newList();
    private ReturnTypeInfo returnType;
    private Map<Label, Map<Integer, LocalVariableMetaInfo>> locals = C.newMap((Object[])new Object[0]);
    private int appCtxLVT_id = -1;

    public SenderMethodMetaInfo(MailerClassMetaInfo clsInfo) {
        this.clsInfo = clsInfo;
    }

    @Override
    protected void releaseResources() {
        this.clsInfo.destroy();
        this.params.clear();
        this.locals.clear();
        super.releaseResources();
    }

    public MailerClassMetaInfo classInfo() {
        return this.clsInfo;
    }

    public SenderMethodMetaInfo name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return S.newBuffer((String)this.clsInfo.className()).a(".").a(this.name()).toString();
    }

    public SenderMethodMetaInfo configId(String id) {
        this.configId = id;
        return this;
    }

    public String configId() {
        return null != this.configId ? this.configId : this.classInfo().configId();
    }

    public SenderMethodMetaInfo invokeStaticMethod() {
        this.invokeType = InvokeType.STATIC;
        return this;
    }

    public SenderMethodMetaInfo invokeInstanceMethod() {
        this.invokeType = InvokeType.VIRTUAL;
        return this;
    }

    public boolean isStatic() {
        return InvokeType.STATIC == this.invokeType;
    }

    public SenderMethodMetaInfo returnType(Type type) {
        this.returnType = ReturnTypeInfo.of(type);
        return this;
    }

    public SenderMethodMetaInfo appCtxLocalVariableTableIndex(int index) {
        this.appCtxLVT_id = index;
        return this;
    }

    public int appCtxLocalVariableTableIndex() {
        return this.appCtxLVT_id;
    }

    public Type returnType() {
        return this.returnType.type();
    }

    public Type returnComponentType() {
        return this.returnType.componentType();
    }

    public SenderMethodMetaInfo returnComponentType(Type type) {
        this.returnType.componentType(type);
        return this;
    }

    public boolean hasReturn() {
        return this.returnType.hasReturn();
    }

    public boolean hasLocalVariableTable() {
        return !this.locals.isEmpty();
    }

    public SenderMethodMetaInfo addParam(HandlerParamMetaInfo param) {
        this.params.add((Object)param);
        if (AsmTypes.ACTION_CONTEXT.equals(param.type())) {
            // empty if block
        }
        return this;
    }

    public SenderMethodMetaInfo addLocal(LocalVariableMetaInfo local) {
        Label start = local.start();
        C.Map m = this.locals.get(start);
        if (null == m) {
            m = C.newMap((Object[])new Object[0]);
            this.locals.put(start, (Map<Integer, LocalVariableMetaInfo>)m);
        }
        int index = local.index();
        E.illegalStateIf((boolean)m.containsKey(index), (String)"Local variable index conflict");
        m.put(local.index(), local);
        return this;
    }

    public LocalVariableMetaInfo localVariable(int index, Label start) {
        Map<Integer, LocalVariableMetaInfo> l = this.locals.get(start);
        if (null == l) {
            return null;
        }
        return l.get(index);
    }

    public HandlerParamMetaInfo param(int id) {
        return (HandlerParamMetaInfo)this.params.get(id);
    }

    public int paramCount() {
        return this.params.size();
    }

    public int hashCode() {
        return $.hc((Object)this.fullName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HandlerMethodMetaInfo) {
            HandlerMethodMetaInfo that = (HandlerMethodMetaInfo)obj;
            return $.eq((Object)that.fullName(), (Object)this.fullName());
        }
        return false;
    }

    public String toString() {
        S.Buffer sb = S.newBuffer();
        sb.append(this._invokeType()).append(this._return()).append(this.fullName()).append("(").append(this._params()).append(")");
        return sb.toString();
    }

    private String _invokeType() {
        if (null == this.invokeType) {
            return "";
        }
        switch (this.invokeType) {
            case VIRTUAL: {
                return "";
            }
            case STATIC: {
                return "static ";
            }
        }
        assert (false);
        return "";
    }

    private String _return() {
        if (null == this.returnType) {
            return " ";
        }
        if (this.returnType.hasReturn()) {
            return this.returnType.type().getClassName() + " ";
        }
        return "";
    }

    private String _params() {
        return S.join((String)", ", (Iterable)this.params.map((Osgl.Function)new Osgl.Transformer<HandlerParamMetaInfo, String>(){

            public String transform(HandlerParamMetaInfo paramMetaInfo) {
                return paramMetaInfo.type().getClassName();
            }
        }));
    }
}

