/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.metric.CountScale;
import act.metric.DurationScale;
import org.osgl.$;
import org.osgl.Osgl;

public class MetricInfo {
    public static final String HTTP_HANDLER = "act:http";
    public static final String CLASS_LOADING = "act:classload";
    public static final String JOB_HANDLER = "act:job";
    public static final String CLI_HANDLER = "act:cli";
    public static final String MAILER = "act:mail";
    public static final String EVENT_HANDLER = "act:event";
    public static final String ROUTING = "act:routing";
    public static final String PATH_SEPARATOR = ":";
    private String name;
    private long count;
    private Long ns;

    MetricInfo(String name, long count) {
        this.name = name;
        this.count = count;
    }

    MetricInfo(String name, long ns, long count) {
        this.name = name;
        this.ns = ns;
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public long getNs() {
        return this.ns;
    }

    public long getMs() {
        return this.ns / 1000L / 1000L;
    }

    public long getSeconds() {
        return this.ns / 1000L / 1000L / 1000L;
    }

    public long getCount() {
        return this.count;
    }

    public String getCountAsStr() {
        return CountScale.format(this.count);
    }

    public long getMsAvg() {
        return this.getMs() / this.count;
    }

    public String getAccumulated() {
        return DurationScale.format(this.ns);
    }

    public String getAvg() {
        return DurationScale.format(this.ns / this.count);
    }

    public int hashCode() {
        return $.hc((Object)this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetricInfo) {
            MetricInfo that = (MetricInfo)obj;
            return $.eq((Object)this.name, (Object)that.name);
        }
        return false;
    }

    public static enum Comparator {

        public static Osgl.Comparator<MetricInfo> COUNTER = new Osgl.Comparator<MetricInfo>(){

            public int compare(MetricInfo m1, MetricInfo m2) {
                long l = m2.count - m1.count;
                if (l < 0L) {
                    return -1;
                }
                if (l == 0L) {
                    return m2.name.compareTo(m1.name);
                }
                return 1;
            }
        };
        public static Osgl.Comparator<MetricInfo> TIMER = new Osgl.Comparator<MetricInfo>(){

            public int compare(MetricInfo m1, MetricInfo m2) {
                long l = null == m1.ns ? m2.count - m1.count : m2.getMsAvg() - m1.getMsAvg();
                if (l < 0L) {
                    return -1;
                }
                if (l == 0L) {
                    return m2.name.compareTo(m1.name);
                }
                return 1;
            }
        };
    }
}

