/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.Act;
import act.app.App;
import act.metric.Metric;
import act.metric.MetricPlugin;
import act.metric.MetricStore;
import act.metric.SimpleMetric;
import act.metric.SimpleMetricStore;
import act.plugin.AppServicePlugin;
import java.util.Map;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class SimpleMetricPlugin
implements MetricPlugin {
    private Map<String, Logger> enabledMap = C.newMap((Object[])new Object[0]);
    private SimpleMetricStore defaultMetricStore = new SimpleMetricStore(this);
    private Metric defaultMetric = new SimpleMetric(this.defaultMetricStore);

    @Override
    public Metric metric(String name) {
        if (!Act.appConfig().metricEnabled()) {
            return Metric.NULL_METRIC;
        }
        Logger logger = this.enabledMap.get(name);
        if (null == logger) {
            logger = LogManager.get((String)("metric." + name));
            this.enabledMap.put(name, logger);
        }
        return logger.isTraceEnabled() ? this.metric() : Metric.NULL_METRIC;
    }

    @Override
    public Metric metric() {
        return this.defaultMetric;
    }

    @Override
    public MetricStore metricStore() {
        return this.defaultMetricStore;
    }

    @Override
    public void enableDataSync(boolean sync) {
        this.defaultMetricStore.enableDataSync(sync);
    }

    Logger logger(String name) {
        return this.enabledMap.get(name);
    }

    public static class SimpleMetricPersistService
    extends AppServicePlugin {
        @Override
        protected void applyTo(App app) {
            if (!app.config().metricEnabled()) {
                return;
            }
            MetricPlugin plugin = Act.metricPlugin();
            if (plugin instanceof SimpleMetricPlugin) {
                SimpleMetricPlugin smp = (SimpleMetricPlugin)plugin;
                final SimpleMetricStore store = (SimpleMetricStore)$.cast((Object)smp.defaultMetricStore);
                Runnable takeSnapshot = new Runnable(){

                    @Override
                    public void run() {
                        store.takeSnapshot();
                    }
                };
                app.jobManager().every("metric:snapshot", takeSnapshot, "1mn");
            }
        }
    }
}

