/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.app.App;
import act.cli.CliContext;
import act.cli.Command;
import act.cli.Optional;
import act.cli.Required;
import act.cli.tree.FilteredTreeNode;
import act.cli.tree.TreeNode;
import act.cli.tree.TreeNodeFilter;
import act.route.DuplicateRouteMappingException;
import act.route.RouteInfo;
import act.route.RouteSource;
import act.route.Router;
import act.util.PropertySpec;
import java.util.Collection;
import java.util.List;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.S;

public class RouterAdmin {
    private App app = App.instance();
    private CliContext context = CliContext.current();

    @Command(name="act.route.list, act.route.print", help="list routes")
    @PropertySpec(value={"method,path,compactHandler"})
    public Object listRoutes(@Optional(value="list routes in tree view") boolean tree, @Optional(value="specify the port name") String name, @Optional(value="specify route filter") String q) {
        Router router;
        Router router2 = router = S.blank((String)name) ? this.app.router() : this.app.router(name);
        if (S.notBlank((String)q) && !q.contains(".") && !q.contains("[") && !q.contains("*")) {
            q = ".*" + q + ".*";
        }
        if (tree) {
            TreeNode root = new TreeNode(){

                @Override
                public String id() {
                    return "root";
                }

                @Override
                public String label() {
                    return "Router";
                }

                @Override
                public List<TreeNode> children() {
                    C.List l = C.newList();
                    l.add(router._GET);
                    l.add(router._POST);
                    l.add(router._PUT);
                    l.add(router._DEL);
                    return l;
                }
            };
            return S.blank((String)q) ? root : new FilteredTreeNode(root, TreeNodeFilter.Common.pathMatches(q));
        }
        return this.routeInfoList(name, q);
    }

    private List<RouteInfo> routeInfoList(String portName, String q) {
        Router router = S.blank((String)portName) ? this.app.router() : this.app.router(portName);
        C.List list = router.debug();
        if (S.notBlank((String)q)) {
            C.List toBeRemoved = C.newList();
            for (RouteInfo info : list) {
                if (info.path().matches(q) || S.string((Object)info.handler()).matches(q)) continue;
                toBeRemoved.add(info);
            }
            list = C.list(list).without((Collection)toBeRemoved);
        }
        return list;
    }

    @Command(name="act.route.overwrite", help="overwrite a route entry")
    public void overwrite(@Required(value="specify http method") String method, @Required(value="specify path") String path, @Required(value="specify handler") String handler, @Optional(value="specify the port name") String name) {
        Router router = S.blank((String)name) ? this.app.router() : this.app.router(name);
        router.addMapping(H.Method.valueOfIgnoreCase((String)method), (CharSequence)path, handler, RouteSource.ADMIN_OVERWRITE);
        this.context.println("route entry has been added/overwritten", new Object[0]);
    }

    @Command(name="act.route.add", help="add a route entry")
    public void add(@Required(value="specify http method") String method, @Required(value="specify URL path") String path, @Required(value="specify handler") String handler, @Optional(value="specify the port name") String name) {
        Router router = S.blank((String)name) ? this.app.router() : this.app.router(name);
        try {
            router.addMapping(H.Method.valueOfIgnoreCase((String)method), (CharSequence)path, handler, RouteSource.ADMIN_ADD);
            this.context.println("route entry has been added", new Object[0]);
        }
        catch (DuplicateRouteMappingException e) {
            this.context.println("Route entry already exist", new Object[0]);
        }
    }

    @Command(name="act.route.echo", help="Add a temporary echo route")
    public void echo(@Required(value="specify URL path") String path, @Required(value="specify the code to echo back") String code, @Optional(value="specify the port name") String name) {
        Router router = S.blank((String)name) ? this.app.router() : this.app.router(name);
        try {
            router.addMapping(H.Method.GET, (CharSequence)path, "echo:" + code, RouteSource.ADMIN_ADD);
            this.context.println("route entry has been added", new Object[0]);
        }
        catch (DuplicateRouteMappingException e) {
            this.context.println("Route entry already exist", new Object[0]);
        }
    }
}

