/*
 * Decompiled with CFR 0.152.
 */
package act.security;

import act.Act;
import act.app.ActionContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collection;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class CORS {
    public static Spec spec(Collection<H.Method> methods) {
        return new Spec(methods);
    }

    public static Spec spec(Class controller) {
        return CORS.spec(BeanSpec.of((Class)controller, Act.injector()));
    }

    public static Spec spec(Method action) {
        Class<Method> type = Method.class;
        Annotation[] annotations = action.getDeclaredAnnotations();
        return CORS.spec(BeanSpec.of(type, (Annotation[])annotations, Act.injector()));
    }

    private static Spec spec(BeanSpec beanSpec) {
        return new Spec().with((Disable)beanSpec.getAnnotation(Disable.class)).with((AllowOrigin)beanSpec.getAnnotation(AllowOrigin.class)).with((ExposeHeaders)beanSpec.getAnnotation(ExposeHeaders.class)).with((AllowHeaders)beanSpec.getAnnotation(AllowHeaders.class)).with((MaxAge)beanSpec.getAnnotation(MaxAge.class));
    }

    public static class Spec
    extends Osgl.Visitor<ActionContext> {
        public static final Spec DUMB = new Spec(){

            @Override
            public void visit(ActionContext context) throws Osgl.Break {
            }

            @Override
            public void applyTo(ActionContext context) throws Osgl.Break {
            }
        };
        private boolean disableCORS;
        private String origin;
        private String methods;
        private String exposeHeaders;
        private String allowHeaders;
        private int maxAge = -1;
        private boolean effective = false;

        private Spec(Collection<H.Method> methodSet) {
            E.illegalArgumentIf((boolean)methodSet.isEmpty());
            this.methods = S.join((String)", ", (Iterable)C.list(methodSet).map((Osgl.Function)Osgl.F.asString()));
            this.effective = true;
        }

        private Spec() {
        }

        public boolean effective() {
            return this.effective;
        }

        public boolean disabled() {
            return this.disableCORS;
        }

        public Spec with(Disable disableCORS) {
            if (null != disableCORS) {
                this.effective = true;
                this.disableCORS = true;
            }
            return this;
        }

        public Spec with(AllowOrigin allowOrigin) {
            if (null != allowOrigin) {
                this.effective = true;
                this.origin = allowOrigin.value();
            }
            return this;
        }

        public Spec with(AllowHeaders allowHeaders) {
            if (null != allowHeaders) {
                this.effective = true;
                this.allowHeaders = allowHeaders.value();
            }
            return this;
        }

        public Spec with(ExposeHeaders exposeHeaders) {
            if (null != exposeHeaders) {
                this.effective = true;
                this.exposeHeaders = exposeHeaders.value();
            }
            return this;
        }

        public Spec with(MaxAge maxAge) {
            if (null != maxAge) {
                this.effective = true;
                this.maxAge = maxAge.value();
            }
            return this;
        }

        public void visit(ActionContext context) throws Osgl.Break {
            this.applyTo(context);
        }

        public void applyTo(ActionContext context) throws Osgl.Break {
            if (!this.effective) {
                return;
            }
            if (this.disableCORS) {
                context.disableCORS();
                return;
            }
            H.Response r = context.resp();
            if (null != this.origin) {
                r.addHeaderIfNotAdded("Access-Control-Allow-Origin", this.origin);
            }
            if (context.isOptionsMethod()) {
                if (null != this.methods) {
                    r.addHeaderIfNotAdded("Access-Control-Allow-Methods", this.methods);
                }
                if (null != this.exposeHeaders) {
                    r.addHeaderIfNotAdded("Access-Control-Expose-Headers", this.exposeHeaders);
                }
                if (null != this.allowHeaders) {
                    r.addHeaderIfNotAdded("Access-Control-Allow-Headers", this.allowHeaders);
                }
                if (-1 < this.maxAge) {
                    r.addHeaderIfNotAdded("Access-Control-Max-Age", S.string((Object)this.maxAge));
                }
            }
        }

        public Spec chain(final Spec next) {
            if (!next.effective()) {
                return this;
            }
            if (!this.effective()) {
                return next;
            }
            if (next.disabled()) {
                return next;
            }
            if (this.disabled()) {
                return this;
            }
            final Spec me = this;
            return new Spec(){

                @Override
                public boolean effective() {
                    return true;
                }

                @Override
                public void applyTo(ActionContext context) throws Osgl.Break {
                    me.visit(context);
                    next.visit(context);
                }
            };
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface MaxAge {
        public int value() default 1800;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface ExposeHeaders {
        public String value() default "*";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface AllowHeaders {
        public String value() default "*";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface AllowOrigin {
        public String value() default "*";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Disable {
    }
}

