/*
 * Decompiled with CFR 0.152.
 */
package act.security;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.conf.AppConfig;
import act.security.CSRFProtector;
import act.util.MissingAuthenticationHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.util.S;

public class CSRF {
    public static String token(ActionContext ctx) {
        String paramName = ctx.config().csrfParamName();
        return (String)ctx.renderArg(paramName);
    }

    public static String formField(ActionContext ctx) {
        String paramName = ctx.config().csrfParamName();
        return S.newBuffer((String)"<input type='hidden' name='").a(paramName).a("' value='").a(ctx.renderArg(paramName)).a("'>").toString();
    }

    public static Spec spec(Class controller) {
        return CSRF.spec(BeanSpec.of((Class)controller, Act.injector()));
    }

    public static Spec spec(Method action) {
        Class<Method> type = Method.class;
        Annotation[] annotations = action.getDeclaredAnnotations();
        return CSRF.spec(BeanSpec.of(type, (Annotation[])annotations, Act.injector()));
    }

    private static Spec spec(BeanSpec beanSpec) {
        if (null != beanSpec.getAnnotation(Enable.class)) {
            return new Spec(true);
        }
        if (null != beanSpec.getAnnotation(Disable.class)) {
            return new Spec(false);
        }
        return Spec.DEFAULT;
    }

    public static class Spec {
        public static final Spec DUMB = new Spec(){

            @Override
            public void preCheck(ActionContext context) {
            }

            @Override
            public void check(ActionContext context, H.Session session) {
            }

            @Override
            public void setCookieAndRenderArgs(ActionContext context) {
            }
        };
        public static final Spec DEFAULT = new Spec();
        private App app = Act.app();
        private Boolean enabled;
        private String paramName;
        private String headerName;
        private String cookieName;
        private String cookieDomain;
        private CSRFProtector csrfProtector;

        private Spec() {
            this((Boolean)null);
        }

        private Spec(Boolean enabled) {
            AppConfig<?> config = this.app.config();
            boolean globalEnabled = config.csrfEnabled();
            this.enabled = null == enabled ? globalEnabled : enabled;
            if (!this.enabled.booleanValue()) {
                return;
            }
            this.paramName = config.csrfParamName();
            this.headerName = config.csrfHeaderName();
            this.cookieName = config.csrfCookieName();
            this.cookieDomain = config.cookieDomain();
            this.csrfProtector = config.csrfProtector();
        }

        private boolean effective() {
            return DUMB != this && DEFAULT != this;
        }

        public void preCheck(ActionContext context) {
            if (!this.enabled.booleanValue()) {
                return;
            }
            H.Method method = context.req().method();
            if (method.safe()) {
                return;
            }
            String token = this.retrieveCsrfToken(context);
            if (S.blank((String)token)) {
                Spec.raiseCsrfNotVerified(context);
            }
        }

        public void check(ActionContext context, H.Session session) {
            if (!this.enabled.booleanValue()) {
                return;
            }
            String token = (String)context.attribute("__csrf_prefetch__");
            try {
                if (!this.csrfProtector.verifyToken(token, session, this.app)) {
                    context.removeAttribute("__csrf_prefetch__");
                    Spec.raiseCsrfNotVerified(context);
                }
            }
            catch (UnexpectedException e) {
                App.logger.warn((Throwable)e, "Error checking CSRF token");
                Spec.raiseCsrfNotVerified(context);
            }
        }

        public Spec chain(Spec next) {
            return this.effective() ? this : next;
        }

        public void setCookieAndRenderArgs(ActionContext context) {
            H.Session session;
            if (!this.enabled.booleanValue()) {
                return;
            }
            String token = this.retrieveCsrfToken(context);
            if (S.blank((String)token)) {
                session = context.session();
                token = this.csrfProtector.retrieveToken(session, this.cookieName, this.app);
            }
            if (S.blank((String)token) || Spec.justLoggedIn(context)) {
                session = context.session();
                this.csrfProtector.clearExistingToken(session, this.cookieName);
                token = this.app.encrypt(this.csrfProtector.generateToken(session, this.app));
                H.Cookie cookie = new H.Cookie(this.cookieName, token);
                cookie.secure(context.config().sessionSecure());
                cookie.domain(this.cookieDomain);
                cookie.path("/");
                context.resp().addCookie(cookie);
                this.csrfProtector.outputToken(token, this.cookieName, this.cookieDomain, context);
            }
            context.renderArg(this.paramName, token);
        }

        private String retrieveCsrfToken(ActionContext context) {
            String token = (String)context.attribute("__csrf_prefetch__");
            if (S.blank((String)token)) {
                token = context.req().header(this.headerName);
            }
            if (S.blank((String)token)) {
                token = context.paramVal(this.paramName);
            }
            if (S.notBlank((String)token)) {
                context.attribute("__csrf_prefetch__", token);
            }
            return token;
        }

        private static boolean justLoggedIn(ActionContext context) {
            boolean wasUnauthenticated = (Boolean)context.attribute("__was_unauthenticated__");
            return wasUnauthenticated && context.isLoggedIn();
        }

        private static void raiseCsrfNotVerified(ActionContext context) {
            AppConfig config = context.config();
            MissingAuthenticationHandler handler = context.isAjax() ? config.ajaxCsrfCheckFailureHandler() : config.csrfCheckFailureHandler();
            context.removeAttribute("__csrf_prefetch__");
            throw handler.result(context);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Disable {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Enable {
    }
}

