/*
 * Decompiled with CFR 0.152.
 */
package act.sys;

import act.Act;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.osgl.util.C;
import org.rythmengine.utils.S;

public final class Env {
    private static final C.Set<Class<? extends Annotation>> ENV_ANNOTATION_TYPES = C.set(Mode.class, (Object[])new Class[]{Profile.class, Group.class});

    private Env() {
    }

    public static boolean matches(Mode modeTag) {
        return modeTag.unless() ^ modeTag.value() == Act.mode();
    }

    public static boolean modeMatches(Act.Mode mode) {
        return mode == Act.mode();
    }

    public static boolean matches(Profile profileTag) {
        return profileTag.unless() ^ S.eq((String)profileTag.value(), (String)Act.profile(), (int)4096);
    }

    public static boolean profileMatches(String profile) {
        return S.eq((String)profile, (String)Act.profile(), (int)4096);
    }

    public static boolean matches(Group groupTag) {
        return groupTag.unless() ^ S.eq((String)groupTag.value(), (String)Act.nodeGroup(), (int)4096);
    }

    public static boolean groupMatches(String group) {
        return S.eq((String)group, (String)Act.nodeGroup(), (int)4096);
    }

    public static boolean isEnvAnnotation(Class<? extends Annotation> type) {
        return ENV_ANNOTATION_TYPES.contains(type);
    }

    public static boolean matches(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        for (Annotation anno : annotations = annotatedElement.getDeclaredAnnotations()) {
            Mode mode;
            Group group;
            Profile profile;
            if (!(anno instanceof Profile ? !Env.matches(profile = (Profile)anno) : (anno instanceof Group ? !Env.matches(group = (Group)anno) : anno instanceof Mode && !Env.matches(mode = (Mode)anno)))) continue;
            return false;
        }
        return true;
    }

    public static class PID {
        private static String pid = PID.getPid();

        private static String getPid() {
            File bash;
            File proc_self = new File("/proc/self");
            if (proc_self.exists()) {
                try {
                    return proc_self.getCanonicalFile().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((bash = new File("/bin/bash")).exists()) {
                ProcessBuilder pb = new ProcessBuilder("/bin/bash", "-c", "echo $PPID");
                try {
                    Process p = pb.start();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    return rd.readLine();
                }
                catch (IOException e) {
                    return String.valueOf(Thread.currentThread().getId());
                }
            }
            return String.valueOf(Thread.currentThread().getId());
        }

        public static String get() {
            return pid;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Mode {
        public Act.Mode value();

        public boolean unless() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Group {
        public String value();

        public boolean unless() default false;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Profile {
        public String value();

        public boolean unless() default false;
    }
}

