/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.cli.CliContext;
import act.conf.AppConfig;
import act.i18n.I18n;
import act.mail.MailerContext;
import act.util.DestroyableBase;
import act.view.Template;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.validation.ConstraintViolation;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.util.ParamValueProvider;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public interface ActContext<CTX_TYPE extends ActContext>
extends ParamValueProvider {
    public App app();

    public AppConfig config();

    public CTX_TYPE accept(H.Format var1);

    public H.Format accept();

    public CTX_TYPE locale(Locale var1);

    public Locale locale();

    public Locale locale(boolean var1);

    public String templatePath();

    public CTX_TYPE templatePath(String var1);

    public boolean templatePathIsImplicit();

    public Template cachedTemplate();

    public CTX_TYPE cacheTemplate(Template var1);

    public <T> T renderArg(String var1);

    public Map<String, Object> renderArgs();

    public CTX_TYPE renderArg(String var1, Object var2);

    public CTX_TYPE addListener(Listener var1);

    public CTX_TYPE addDestroyable(Destroyable var1);

    public CTX_TYPE attribute(String var1, Object var2);

    public <T> T attribute(String var1);

    public Map<String, Object> attributes();

    public CTX_TYPE removeAttribute(String var1);

    public CTX_TYPE addViolations(Map<String, ConstraintViolation> var1);

    public CTX_TYPE addViolation(String var1, ConstraintViolation var2);

    public boolean hasViolation();

    public Map<String, ConstraintViolation> violations();

    public ConstraintViolation violation(String var1);

    public String i18n(boolean var1, String var2, Object ... var3);

    public String i18n(String var1, Object ... var2);

    public String i18n(Class<?> var1, String var2, Object ... var3);

    public String i18n(boolean var1, Class<?> var2, String var3, Object ... var4);

    public String i18n(Enum<?> var1);

    public String i18n(Class<?> var1, Enum<?> var2);

    public Map<String, Object> i18n(Class<? extends Enum> var1);

    public Map<String, Object> i18n(Class<?> var1, Class<? extends Enum> var2);

    public Map<String, Object> i18n(Class<? extends Enum> var1, boolean var2);

    public Map<String, Object> i18n(Class<?> var1, Class<? extends Enum> var2, boolean var3);

    public String methodPath();

    public S.Buffer strBuf();

    public static abstract class Base<CTX extends Base>
    extends DestroyableBase
    implements ActContext<CTX> {
        private App app;
        private String templatePath;
        private Template template;
        private Map<String, Object> renderArgs;
        private List<Listener> listenerList;
        private List<Destroyable> destroyableList;
        private Map<String, Object> attributes;
        private Locale locale;
        private S.Buffer strBuf;
        private Map<String, ConstraintViolation> violations;
        public static final String DEF_RESOURCE_BUNDLE_NAME = "messages";

        public Base(App app) {
            E.NPE((Object)app);
            this.app = app;
            this.renderArgs = new HashMap<String, Object>();
            this.attributes = new HashMap<String, Object>();
            this.listenerList = new ArrayList<Listener>();
            this.destroyableList = new ArrayList<Destroyable>();
            this.strBuf = S.newBuffer();
            this.violations = new HashMap<String, ConstraintViolation>();
        }

        @Override
        protected void releaseResources() {
            for (Listener l : this.listenerList) {
                try {
                    l.onDestroy(this);
                }
                catch (Exception e) {
                    App.LOGGER.warn((Throwable)e, "error calling listener onDestroy method");
                }
            }
            Destroyable.Util.destroyAll(this.destroyableList, RequestScoped.class);
            Destroyable.Util.tryDestroyAll(this.attributes.values(), RequestScoped.class);
            this.attributes.clear();
            this.renderArgs.clear();
            this.template = null;
            this.app = null;
            this.template = null;
            this.listenerList.clear();
            this.destroyableList.clear();
            this.violations.clear();
        }

        @Override
        public App app() {
            return this.app;
        }

        @Override
        public AppConfig config() {
            return this.app().config();
        }

        @Override
        public String templatePath() {
            return this.templatePath;
        }

        @Override
        public CTX templatePath(String templatePath) {
            this.template = null;
            this.templatePath = templatePath;
            return this.me();
        }

        @Override
        public boolean templatePathIsImplicit() {
            return null == this.templatePath;
        }

        @Override
        public Template cachedTemplate() {
            return this.template;
        }

        @Override
        public CTX cacheTemplate(Template template) {
            this.template = template;
            return this.me();
        }

        @Override
        public final CTX locale(Locale locale) {
            this.locale = locale;
            return this.me();
        }

        @Override
        public final Locale locale() {
            return this.locale;
        }

        @Override
        public Locale locale(boolean required) {
            Locale locale = this.locale;
            if (null == locale) {
                if (!required) {
                    return null;
                }
                locale = this.config().locale();
            }
            return locale;
        }

        @Override
        public String i18n(boolean ignoreError, String msgId, Object ... args) {
            return I18n.i18n(ignoreError, this.locale(true), DEF_RESOURCE_BUNDLE_NAME, msgId, args);
        }

        @Override
        public String i18n(String msgId, Object ... args) {
            return I18n.i18n(this.locale(true), DEF_RESOURCE_BUNDLE_NAME, msgId, args);
        }

        @Override
        public String i18n(Class<?> bundleSpec, String msgId, Object ... args) {
            return I18n.i18n(this.locale(true), bundleSpec.getName(), msgId, args);
        }

        @Override
        public String i18n(boolean ignoreError, Class<?> bundleSpec, String msgId, Object ... args) {
            return I18n.i18n(ignoreError, this.locale(true), bundleSpec.getName(), msgId, args);
        }

        @Override
        public String i18n(Enum<?> msgId) {
            return I18n.i18n(this.locale(true), DEF_RESOURCE_BUNDLE_NAME, msgId);
        }

        @Override
        public String i18n(Class<?> bundleSpec, Enum<?> msgId) {
            return I18n.i18n(this.locale(true), bundleSpec.getName(), msgId);
        }

        @Override
        public Map<String, Object> i18n(Class<? extends Enum> enumClass) {
            return I18n.i18n(this.locale(true), enumClass);
        }

        @Override
        public Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass) {
            return I18n.i18n(this.locale(true), bundleSpec, enumClass);
        }

        @Override
        public Map<String, Object> i18n(Class<? extends Enum> enumClass, boolean outputPropeties) {
            return I18n.i18n(this.locale(true), enumClass, outputPropeties);
        }

        @Override
        public Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass, boolean outputProperties) {
            return I18n.i18n(this.locale(true), bundleSpec, enumClass, outputProperties);
        }

        protected CTX me() {
            return (CTX)this;
        }

        @Override
        public <T> T renderArg(String name) {
            return (T)this.renderArgs.get(name);
        }

        @Override
        public CTX renderArg(String name, Object val) {
            this.renderArgs.put(name, val);
            return this.me();
        }

        @Override
        public Map<String, Object> renderArgs() {
            return C.newMap(this.renderArgs);
        }

        @Override
        public CTX attribute(String name, Object attr) {
            this.attributes.put(name, attr);
            return this.me();
        }

        @Override
        public <T> T attribute(String name) {
            return (T)$.cast((Object)this.attributes.get(name));
        }

        @Override
        public CTX removeAttribute(String name) {
            this.attributes.remove(name);
            return this.me();
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public CTX addListener(Listener listener) {
            this.listenerList.add(listener);
            return this.me();
        }

        @Override
        public CTX addDestroyable(Destroyable resource) {
            this.destroyableList.add(resource);
            return this.me();
        }

        @Override
        public S.Buffer strBuf() {
            return this.strBuf.consumed() ? this.strBuf.reset() : S.newBuffer();
        }

        @Override
        public CTX addViolations(Map<String, ConstraintViolation> violations) {
            this.violations.putAll(violations);
            return this.me();
        }

        @Override
        public CTX addViolation(String property, ConstraintViolation violation) {
            this.violations.put(property, violation);
            return this.me();
        }

        @Override
        public boolean hasViolation() {
            return !this.violations.isEmpty();
        }

        @Override
        public Map<String, ConstraintViolation> violations() {
            return C.map(this.violations);
        }

        @Override
        public ConstraintViolation violation(String property) {
            return this.violations.get(property);
        }

        public static ActContext currentContext() {
            Base ctx = ActionContext.current();
            if (null != ctx) {
                return ctx;
            }
            ctx = MailerContext.current();
            if (null != ctx) {
                return ctx;
            }
            ctx = CliContext.current();
            if (null != ctx) {
                return ctx;
            }
            return null;
        }

        public static Class<? extends ActContext> currentContextType() {
            ActContext ctx = Base.currentContext();
            return null == ctx ? null : ctx.getClass();
        }
    }

    public static interface Listener {
        public void onDestroy(ActContext var1);
    }
}

