/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.App;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.app.SourceInfo;
import act.app.SourceInfoImpl;
import java.lang.reflect.Method;
import java.util.List;
import org.osgl.util.C;
import org.osgl.util.S;

public interface ActError {
    public Throwable getCauseOrThis();

    public SourceInfo sourceInfo();

    public List<String> stackTrace();

    public boolean isErrorSpot(String var1, String var2);

    public static class Util {
        public static List<String> stackTraceOf(Throwable t, ActError root) {
            C.List l = C.newList();
            while (null != t) {
                StackTraceElement[] a;
                for (StackTraceElement e : a = t.getStackTrace()) {
                    l.add("at " + e.toString());
                }
                if ((t = t.getCause()) == root) break;
                if (null == t) continue;
                l.add("Caused by " + t.toString());
            }
            return l;
        }

        public static SourceInfo loadSourceInfo(StackTraceElement[] stackTraceElements, Class<? extends ActError> errClz) {
            DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                Source source;
                int line = stackTraceElement.getLineNumber();
                if (line <= 0) continue;
                String className = stackTraceElement.getClassName();
                if (S.eq((String)errClz.getName(), (String)className) || null == (source = cl.source(className))) continue;
                return new SourceInfoImpl(source, line);
            }
            return null;
        }

        public static SourceInfo loadSourceInfo(Method method) {
            DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
            String className = method.getDeclaringClass().getName();
            Source source = cl.source(className);
            if (null == className) {
                return null;
            }
            List<String> lines = source.lines();
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (!line.matches("^\\s*.*" + method.getName() + "\\s*\\(.*")) continue;
                return new SourceInfoImpl(source, i + 1);
            }
            return new SourceInfoImpl(source, 1);
        }
    }
}

