/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Destroyable;
import act.app.App;
import act.app.AppByteCodeScanner;
import act.app.AppCodeScannerManager;
import act.app.AppSourceCodeScanner;
import act.util.AppCodeScannerPluginBase;
import act.util.DestroyableBase;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class AppCodeScannerPluginManager
extends DestroyableBase {
    private static final Logger logger = L.get(AppCodeScannerPluginManager.class);
    private Map<Class<? extends AppCodeScannerPluginBase>, AppCodeScannerPluginBase> registry = C.newMap((Object[])new Object[0]);

    public void register(AppCodeScannerPluginBase plugin) {
        Class<?> clz = plugin.getClass();
        if (this.registry.containsKey(clz)) {
            logger.warn("%s has already been registered", new Object[]{clz});
            return;
        }
        this.registry.put(clz, plugin);
    }

    public void initApp(App app) {
        AppCodeScannerManager manager = app.scannerManager();
        for (AppCodeScannerPluginBase plugin : this.registry.values()) {
            AppByteCodeScanner byteCodeScanner;
            AppSourceCodeScanner sourceCodeScanner = plugin.createAppSourceCodeScanner(app);
            if (null != sourceCodeScanner) {
                manager.register(sourceCodeScanner);
            }
            if (null == (byteCodeScanner = plugin.createAppByteCodeScanner(app))) continue;
            manager.register(byteCodeScanner);
        }
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.registry.values(), ApplicationScoped.class);
        this.registry.clear();
    }
}

