/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.asm.AnnotationVisitor;
import act.asm.ClassWriter;
import act.asm.Type;
import act.plugin.Extends;
import act.util.ByteCodeVisitor;
import act.util.ClassFilter;
import java.lang.annotation.Annotation;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class ClassDetector
extends ByteCodeVisitor {
    protected static final Logger logger = L.get(ClassDetector.class);
    private String className;

    public abstract boolean found();

    public String className() {
        return this.className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = Type.getObjectType((String)name).getClassName();
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private static boolean isExtendsAnnotation(String desc) {
        return ClassDetector.isAnnotation(Extends.class, desc);
    }

    private static boolean isAnnotation(Class<? extends Annotation> annoType, String desc) {
        return S.eq((String)annoType.getName(), (String)Type.getType((String)desc).getClassName());
    }

    public static ClassDetector chain(ClassWriter cw, ClassFilter ... filters) {
        return (ClassDetector)ClassDetector.chain(cw, ClassDetector.of(filters), new ByteCodeVisitor[0]);
    }

    public static ClassDetector of(final ClassFilter ... filters) {
        E.illegalArgumentIf((filters.length == 0 ? 1 : 0) != 0);
        if (filters.length == 1) {
            return new FilteredClassDetector(filters[0]);
        }
        return new ClassDetector(){
            C.List<ClassDetector> detectors;
            private C.List<ClassDetector> matches;
            {
                this.detectors = C.listOf((Object[])filters).map((Osgl.Function)new Osgl.F1<ClassFilter, ClassDetector>(){

                    public ClassDetector apply(ClassFilter classFilter) throws NotAppliedException, Osgl.Break {
                        return new FilteredClassDetector(classFilter);
                    }
                });
                this.matches = C.newList();
            }

            public int hashCode() {
                return $.hc(this.detectors);
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                for (ClassDetector detector : this.detectors) {
                    detector.visit(version, access, name, signature, superName, interfaces);
                    if (!detector.found()) continue;
                    this.matches.add((Object)detector);
                }
            }

            public AnnotationVisitor visitAnnotation(final String desc, final boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (this.matches.size() == this.detectors.size() || !ClassDetector.isExtendsAnnotation(desc)) {
                    return av;
                }
                final C.List unmatched = this.detectors.without(this.matches);
                return new AnnotationVisitor(327680, av){

                    public void visit(String name, Object value) {
                        super.visit(name, value);
                        for (ClassDetector detector : unmatched) {
                            AnnotationVisitor av0 = detector.visitAnnotation(desc, visible);
                            av0.visit(name, value);
                            if (!detector.found()) continue;
                            matches.add((Object)detector);
                        }
                    }
                };
            }

            @Override
            public boolean found() {
                return !this.matches.isEmpty();
            }
        };
    }

    private static class FilteredClassDetector
    extends ClassDetector {
        private final ClassFilter filter;
        private boolean found = false;
        private boolean skip = false;

        FilteredClassDetector(ClassFilter filter) {
            E.NPE((Object)filter);
            this.filter = filter;
        }

        public int hashCode() {
            return $.hc((Object)this.filter, FilteredClassDetector.class);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FilteredClassDetector) {
                FilteredClassDetector that = (FilteredClassDetector)((Object)obj);
                return $.eq((Object)that.filter, (Object)this.filter);
            }
            return false;
        }

        @Override
        public boolean found() {
            return this.found;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            if (this.filter.noAbstract() && ((access & 0x400) != 0 || (access & 0x200) != 0)) {
                this.skip = true;
                return;
            }
            if (this.filter.publicOnly() && (access & 1) != 1) {
                this.skip = true;
                return;
            }
            Class superType = this.filter.superType();
            if (null == superType) {
                return;
            }
            String expected = superType.getName();
            if (this.checkName(expected, superName)) {
                this.found = true;
                return;
            }
            for (String s : interfaces) {
                if (!this.checkName(expected, s)) continue;
                this.found = true;
                return;
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (this.found || this.skip) {
                return av;
            }
            if (ClassDetector.isExtendsAnnotation(desc)) {
                Class superType = this.filter.superType();
                if (null != superType) {
                    return new ExtendedAnnotationVisitor(av, superType.getName());
                }
                return av;
            }
            Class annoType = this.filter.annotationType();
            if (null == annoType) {
                return av;
            }
            if (ClassDetector.isAnnotation(annoType, desc)) {
                this.found = true;
            }
            return av;
        }

        private boolean checkName(String expected, String found) {
            Type type = Type.getObjectType((String)found);
            return type.getClassName().equals(expected);
        }

        private final class ExtendedAnnotationVisitor
        extends AnnotationVisitor {
            private String expected;

            public ExtendedAnnotationVisitor(AnnotationVisitor av, String expected) {
                super(327680, av);
                this.expected = expected;
            }

            public void visit(String name, Object value) {
                super.visit(name, value);
                FilteredClassDetector.this.found = FilteredClassDetector.this.found || "value".equals(name) && value instanceof Type && ((Type)value).getClassName().equals(this.expected);
            }
        }
    }
}

