/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.Destroyable;
import act.util.ClassNode;
import act.util.ClassNodeDTO;
import act.util.DestroyableBase;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.util.C;

@ApplicationScoped
public class ClassInfoRepository
extends DestroyableBase {
    protected ConcurrentMap<String, ClassNode> classes = new ConcurrentHashMap<String, ClassNode>();

    public boolean has(String className) {
        return this.classes.containsKey(className);
    }

    public ClassNode node(String name) {
        ClassNode newNode;
        String cname = ClassInfoRepository.canonicalName(name);
        ClassNode node = (ClassNode)this.classes.get(cname);
        if (null == node && null == (node = this.classes.putIfAbsent(cname, newNode = new ClassNode(name.replace('/', '.'), cname, this)))) {
            node = newNode;
        }
        return node;
    }

    public ClassNode node(String name, String canonicalName) {
        ClassNode newNode;
        String cname = ClassInfoRepository.canonicalName(name);
        ClassNode node = (ClassNode)this.classes.get(name);
        if (null == node && null == (node = this.classes.putIfAbsent(cname, newNode = new ClassNode(name.replace('/', '.'), canonicalName, this)))) {
            node = newNode;
        }
        return node;
    }

    public boolean isEmpty() {
        return this.classes.isEmpty();
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.classes.values(), ApplicationScoped.class);
        this.classes.clear();
    }

    public Map<String, ClassNode> classes() {
        return C.map(this.classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSON() {
        ArrayList<ClassNodeDTO> list = new ArrayList<ClassNodeDTO>();
        for (ClassNode node : this.classes.values()) {
            list.add(node.toDTO());
        }
        ClassLoader cl0 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassNodeDTO.class.getClassLoader());
            String string = JSON.toJSONString(list);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl0);
        }
    }

    public static String canonicalName(Class c) {
        try {
            return c.getCanonicalName();
        }
        catch (InternalError e) {
            return null;
        }
        catch (IllegalAccessError e) {
            return null;
        }
    }

    public int hashCode() {
        return $.hc(this.classes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassInfoRepository) {
            ClassInfoRepository that = (ClassInfoRepository)$.cast((Object)obj);
            return $.eq(that.classes, this.classes);
        }
        return false;
    }

    public static String canonicalName(String name) {
        return name.replace('/', '.').replace('$', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfoRepository parseJSON(String json) {
        ClassNode classNode;
        List list;
        ClassInfoRepository repo = new ClassInfoRepository();
        ClassLoader cl0 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassNodeDTO.class.getClassLoader());
            list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<ClassNodeDTO>>(){}, (Feature[])new Feature[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl0);
        }
        for (ClassNodeDTO dto : list) {
            classNode = dto.toClassNode(repo);
            repo.classes.putIfAbsent(dto.getCanonicalName(), classNode);
        }
        for (ClassNodeDTO dto : list) {
            ClassNode node;
            classNode = (ClassNode)repo.classes.get(dto.getCanonicalName());
            if (dto.parent != null) {
                ClassNode parentNode = (ClassNode)repo.classes.get(dto.parent);
                if (null == parentNode) {
                    Act.LOGGER.warn("Error de-serializing ClassInfoRepository: parent[%s] not found for classNode[%s]", new Object[]{dto.parent, dto.canonicalName});
                } else {
                    parentNode.addChild(classNode);
                }
            }
            for (String name : dto.annotated) {
                node = (ClassNode)repo.classes.get(name);
                if (null == node) {
                    Act.LOGGER.warn("Error de-serializing ClassInfoRepository: annotated[%s] not found for classNode[%s]", new Object[]{name, dto.canonicalName});
                    continue;
                }
                classNode.addAnnontated(node);
            }
            for (String name : dto.annotations) {
                node = (ClassNode)repo.classes.get(name);
                if (null == node) {
                    Act.LOGGER.warn("Error de-serializing ClassInfoRepository: annotation[%s] not found for classNode[%s]", new Object[]{name, dto.canonicalName});
                    continue;
                }
                classNode.addAnnotation(node);
            }
            for (String name : dto.interfaces) {
                node = (ClassNode)repo.classes.get(name);
                if (null == node) {
                    Act.LOGGER.warn("Error de-serializing ClassInfoRepository: interface[%s] not found for classNode[%s]", new Object[]{name, dto.canonicalName});
                    continue;
                }
                classNode.addInterface(node);
            }
        }
        return repo;
    }
}

