/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.TreeSet;

public class FastJsonIterableSerializer
implements ObjectSerializer {
    public static final FastJsonIterableSerializer instance = new FastJsonIterableSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        Type elementType = null;
        if (serializer.isEnabled(SerializerFeature.WriteClassName) && fieldType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)fieldType;
            elementType = param.getActualTypeArguments()[0];
        }
        Iterable iterable = (Iterable)object;
        SerialContext context = serializer.getContext();
        serializer.setContext(context, object, fieldName, 0);
        if (serializer.isEnabled(SerializerFeature.WriteClassName)) {
            if (HashSet.class == iterable.getClass()) {
                out.append((CharSequence)"Set");
            } else if (TreeSet.class == iterable.getClass()) {
                out.append((CharSequence)"TreeSet");
            }
        }
        try {
            int i = 0;
            out.append('[');
            for (Object item : iterable) {
                if (i++ != 0) {
                    out.append(',');
                }
                if (item == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt(((Integer)item).intValue());
                    continue;
                }
                if (clazz == Long.class) {
                    out.writeLong(((Long)item).longValue());
                    if (!out.isEnabled(SerializerFeature.WriteClassName)) continue;
                    out.write(76);
                    continue;
                }
                ObjectSerializer itemSerializer = serializer.getObjectWriter(clazz);
                itemSerializer.write(serializer, item, (Object)(i - 1), elementType, 0);
            }
            out.append(']');
        }
        finally {
            serializer.setContext(context);
        }
    }
}

