/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.data.util.StringOrPattern;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.osgl.util.C;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public class FastJsonPropertyPreFilter
implements PropertyPreFilter {
    public static final Pattern PROPERTY_SEPARATOR = Pattern.compile("[,;:]+");
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private final List<String> fullPaths = C.newList();
    private static final Pattern SQUARE_BLOCK = Pattern.compile("\\[.*\\]");
    private static Map<Collection<String>, List<StringOrPattern>> spCache = C.newMap((Object[])new Object[0]);

    public FastJsonPropertyPreFilter(String ... properties) {
        this.addIncludes(properties);
    }

    public void setFullPaths(List<String> ls) {
        this.fullPaths.clear();
        this.fullPaths.addAll(ls);
    }

    public void addIncludes(String ... properties) {
        this.addTo(this.includes, properties);
    }

    public void addIncludes(Collection<String> properties) {
        String[] sa = new String[properties.size()];
        this.addIncludes(properties.toArray(sa));
    }

    public void addExcludes(String ... properties) {
        this.addTo(this.excludes, properties);
    }

    public void addExcludes(Set<String> properties) {
        String[] sa = new String[properties.size()];
        this.addTo(this.excludes, properties.toArray(sa));
    }

    private void addTo(Set<String> set, String ... properties) {
        for (String s : properties) {
            String[] sa;
            if (S.blank((String)s)) continue;
            for (String s0 : sa = PROPERTY_SEPARATOR.split(s)) {
                this.addOneTo(set, s0);
            }
        }
    }

    private void addOneTo(Set<String> set, String path) {
        if (path.contains("/")) {
            path = path.replace('/', '.');
        }
        set.add(path);
    }

    public boolean apply(JSONSerializer serializer, Object source, String name) {
        if (source == null) {
            return true;
        }
        FastStr fs = FastStr.of((String)serializer.getContext().toString()).append(Character.valueOf('.')).append(name);
        String path = fs.substring(fs.indexOf(46) + 1);
        return !this.matches(this.excludes, path, true) && (this.includes.isEmpty() || this.matches(this.includes, path, false));
    }

    private boolean matches(Set<String> paths, String path, boolean exclude) {
        if (path.contains("[")) {
            path = SQUARE_BLOCK.matcher(path).replaceAll("");
        }
        if (paths.contains(path)) {
            return true;
        }
        for (String s : paths) {
            if (!path.startsWith(S.concat((String)s, (String)"."))) continue;
            return true;
        }
        if (FastJsonPropertyPreFilter.hasPattern(paths)) {
            return this.patternMatches(paths, path, exclude);
        }
        if (exclude) {
            return false;
        }
        path = path + ".";
        for (String s : paths) {
            if (!s.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPattern(Collection<String> paths) {
        return S.join((String)"", paths).contains("*");
    }

    private boolean patternMatches(Set<String> paths, String path, boolean exclude) {
        List<StringOrPattern> spList = FastJsonPropertyPreFilter.spList(paths);
        for (StringOrPattern sp : spList) {
            if (sp.matches(path)) {
                return true;
            }
            if (exclude || !sp.isPattern()) continue;
            Pattern p = Pattern.compile(path + "(\\.)?" + sp.s());
            for (String fp : this.fullPaths) {
                if (!p.matcher(fp).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static List<StringOrPattern> spList(Collection<String> strings) {
        C.List ret = spCache.get(strings);
        if (null == ret) {
            ret = C.newList();
            for (String s : strings) {
                ret.add(new StringOrPattern(s));
            }
            spCache.put(strings, (List<StringOrPattern>)ret);
        }
        return ret;
    }
}

