/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.exception.ActException;
import act.util.Files;
import act.util.FsEvent;
import act.util.FsEventListener;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class FsChangeDetector {
    protected static Logger logger = L.get(FsChangeDetector.class);
    private C.List<FsEventListener> listeners = C.newList();
    private final File dir;
    private final Osgl.Predicate<String> fileNameFilter;
    private final Map<String, Long> timestamps = C.newMap((Object[])new Object[0]);
    private final int contextLen;
    private final String context;
    private final Osgl.Var<Long> lastChecksum = $.var((Object)0L);

    public FsChangeDetector(File file, Osgl.Predicate<String> fileNameFilter) {
        this.dir = file;
        this.fileNameFilter = fileNameFilter;
        this.context = file.getAbsolutePath();
        this.contextLen = this.context.length();
        this.initialWalkThrough();
    }

    public FsChangeDetector(File file, Osgl.Predicate<String> fileNameFilter, FsEventListener ... listeners) {
        this(file, fileNameFilter);
        this.listeners.append(C.listOf((Object[])listeners));
    }

    public void registerListener(FsEventListener listener) {
        this.listeners.append((Object)listener);
    }

    public void detectChanges() {
        Osgl.Var checksum = $.var((Object)0L);
        Map<String, Long> newTimestamps = this.walkThrough(this.dir, (Osgl.Var<Long>)checksum);
        if (!((Long)checksum.get()).equals(this.lastChecksum.get())) {
            if (this.dir.isDirectory()) {
                this.check(newTimestamps);
                this.timestamps.clear();
                this.timestamps.putAll(newTimestamps);
            } else {
                this.trigger(new FsEvent(FsEvent.Kind.MODIFY, this.dir.getAbsolutePath()));
            }
            this.lastChecksum.set(checksum);
        }
    }

    private void initialWalkThrough() {
        this.walkThrough(this.dir, this.timestamps, this.lastChecksum);
    }

    private Map<String, Long> walkThrough(File file, Osgl.Var<Long> checksum) {
        C.Map map = C.newMap((Object[])new Object[0]);
        this.walkThrough(file, (Map<String, Long>)map, checksum);
        return map;
    }

    private void check(Map<String, Long> newTimestamps) {
        C.Set retained;
        C.Set<String> modified;
        C.Set removed;
        C.List events = C.newSizedList((int)3);
        C.Set set0 = C.set(this.timestamps.keySet());
        C.Set set1 = C.set(newTimestamps.keySet());
        C.Set added = set1.without((Collection)set0);
        if (!added.isEmpty()) {
            events.add((Object)this.createEvent(FsEvent.Kind.CREATE, (C.Set<String>)added));
        }
        if (!(removed = set0.without((Collection)set1)).isEmpty()) {
            events.add((Object)this.createEvent(FsEvent.Kind.DELETE, (C.Set<String>)removed));
        }
        if (!(modified = this.modified((C.Set<String>)(retained = set1.withIn((Collection)set0)), newTimestamps)).isEmpty()) {
            events.add((Object)this.createEvent(FsEvent.Kind.MODIFY, modified));
        }
        if (!events.isEmpty()) {
            this.trigger((FsEvent[])events.toArray((Object[])new FsEvent[events.size()]));
        }
    }

    private FsEvent createEvent(FsEvent.Kind kind, C.Set<String> paths) {
        return new FsEvent(kind, this.prependContext(paths));
    }

    private C.Set<String> modified(C.Set<String> retained, Map<String, Long> newTimestamps) {
        C.Set modified = C.newSet();
        for (String path : retained) {
            long ts1;
            long ts0 = this.timestamps.get(path);
            if (ts0 == (ts1 = newTimestamps.get(path).longValue())) continue;
            modified.add((Object)path);
        }
        return modified;
    }

    private Set<String> prependContext(C.Set<String> paths) {
        return C.set((Iterable)paths.map((Osgl.Function)new Osgl.F1<String, String>(){

            public String apply(String s) throws NotAppliedException, Osgl.Break {
                return FsChangeDetector.this.context + s;
            }
        }));
    }

    private void walkThrough(File file, Map<String, Long> timestamps, Osgl.Var<Long> checksum) {
        if (file.isDirectory()) {
            Files.filter(file, this.fileNameFilter, this.visitor(timestamps, checksum));
        } else {
            if (!file.exists()) {
                throw new ActException("File deleted: %s", this.dir);
            }
            checksum.set((Object)file.lastModified());
        }
    }

    private Osgl.Visitor<File> visitor(final Map<String, Long> timestamps, final Osgl.Var<Long> checksum) {
        return new Osgl.Visitor<File>(){

            public void visit(File file) throws Osgl.Break {
                long ts = file.lastModified();
                String path = file.getAbsolutePath().substring(FsChangeDetector.this.contextLen);
                checksum.set((Object)((Long)checksum.get() + (long)path.hashCode() + ts));
                timestamps.put(file.getAbsolutePath().substring(FsChangeDetector.this.contextLen), file.lastModified());
            }
        };
    }

    private void trigger(FsEvent ... events) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            FsEventListener l = (FsEventListener)this.listeners.get(i);
            l.on(events);
        }
    }
}

