/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.asm.AnnotationVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class GeneralAnnoInfo {
    private Type type;
    private Map<String, Object> attributes = C.newMap((Object[])new Object[0]);
    private Map<String, List<Object>> listAttributes = C.newMap((Object[])new Object[0]);

    public GeneralAnnoInfo(Type type) {
        E.NPE((Object)type);
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public Class annotationClass(ClassLoader classLoader) {
        return $.classForName((String)this.type.getClassName(), (ClassLoader)classLoader);
    }

    public Map<String, Object> attributes() {
        return C.map(this.attributes);
    }

    public Map<String, List<Object>> listAttributes() {
        return C.map(this.listAttributes);
    }

    public GeneralAnnoInfo addAnnotation(String name, Type type) {
        GeneralAnnoInfo anno = new GeneralAnnoInfo(type);
        this.attributes.put(name, anno);
        return anno;
    }

    public void putAttribute(String name, Object val) {
        this.attributes.put(name, val);
    }

    public void putListAttribute(String name, Object val) {
        C.List vals = this.listAttributes.get(name);
        if (null == vals) {
            vals = C.newList((Object)val);
            this.listAttributes.put(name, (List<Object>)vals);
        } else {
            vals.add(val);
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List<Object> getListAttributes(String name) {
        return this.listAttributes.get(name);
    }

    public int hashCode() {
        return $.hc((Object)this.type, this.attributes, this.listAttributes);
    }

    public String toString() {
        C.List keys = C.newList(this.attributes.keySet()).append(this.listAttributes.keySet()).sorted();
        S.Buffer sb = S.newBuffer((String)"@").append(this.type.getClassName()).append("(");
        for (String key : keys) {
            List<Object> v = this.attributes.get(key);
            if (null == v) {
                v = this.listAttributes.get(v);
            }
            sb.append(key).append("=").append(v).append(", ");
        }
        if (!keys.isEmpty()) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    public <T extends Annotation> T toAnnotation() {
        return AnnotationInvocationHandler.proxy(this);
    }

    public static class AnnotationInvocationHandler<T extends Annotation>
    implements Annotation,
    InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 8157022630814320170L;
        private final GeneralAnnoInfo annoInfo;
        private final Class<T> annotationType;
        private final int hashCode;
        private final Map<String, Object> values;

        AnnotationInvocationHandler(GeneralAnnoInfo annoInfo, ClassLoader classLoader) {
            this.annotationType = $.classForName((String)annoInfo.type().getClassName(), (ClassLoader)classLoader);
            this.annoInfo = annoInfo;
            this.hashCode = annoInfo.hashCode();
            this.values = this.retrieveAnnotationValues(annoInfo, this.annotationType);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String key = method.getName();
            Object val = this.values.get(key);
            return null == val ? method.invoke((Object)this, args) : val;
        }

        private <T> Object toArray(List<Object> list) {
            Class<?> c = list.get(0).getClass();
            int size = list.size();
            if (c == String.class) {
                return list.toArray(new String[size]);
            }
            if (c == Class.class) {
                return list.toArray(new Class[size]);
            }
            if (c == Boolean.class) {
                return $.asPrimitive((Boolean[])list.toArray(new Boolean[size]));
            }
            if (c == Byte.class) {
                return $.asPrimitive((Byte[])list.toArray(new Byte[size]));
            }
            if (c == Short.class) {
                return $.asPrimitive((Short[])list.toArray(new Short[size]));
            }
            if (c == Character.class) {
                return $.asPrimitive((Character[])list.toArray(new Character[size]));
            }
            if (c == Integer.class) {
                return $.asPrimitive((Integer[])list.toArray(new Integer[size]));
            }
            if (c == Float.class) {
                return $.asPrimitive((Float[])list.toArray(new Float[size]));
            }
            if (c == Long.class) {
                return $.asPrimitive((Long[])list.toArray(new Long[size]));
            }
            if (c == Double.class) {
                return $.asPrimitive((Double[])list.toArray(new Double[size]));
            }
            return list.toArray((Object[])Array.newInstance(c, size));
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        @Override
        public boolean equals(Object obj) {
            Object otherValue;
            Object value;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.annotationType.isInstance(obj)) {
                return false;
            }
            Annotation other = (Annotation)this.annotationType.cast(obj);
            for (Map.Entry member : this.annoInfo.attributes.entrySet()) {
                value = member.getValue();
                if ($.eq2(value, (Object)(otherValue = this.getAnnotationMemberValue(other, (String)member.getKey())))) continue;
                return false;
            }
            for (Map.Entry member : this.annoInfo.listAttributes.entrySet()) {
                value = this.toArray((List)member.getValue());
                if ($.eq2(value, (Object)(otherValue = this.getAnnotationMemberValue(other, (String)member.getKey())))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String toString() {
            return this.annoInfo.toString();
        }

        private Map<String, Object> retrieveAnnotationValues(GeneralAnnoInfo info, Class<T> type) {
            Method[] ma;
            C.Map bag = C.newMap((Object[])new Object[0]);
            for (String key : info.attributes.keySet()) {
                bag.put(key, info.getAttribute(key));
            }
            for (String key : info.listAttributes.keySet()) {
                bag.put(key, this.toArray(info.getListAttributes(key)));
            }
            for (Method m : ma = type.getDeclaredMethods()) {
                String mn = m.getName();
                if (bag.containsKey(mn)) continue;
                bag.put(mn, m.getDefaultValue());
            }
            return bag;
        }

        private Object getAnnotationMemberValue(Annotation annotation, String name) {
            try {
                Method method = annotation.getClass().getMethod(name, new Class[0]);
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }

        public static <T extends Annotation> T proxy(GeneralAnnoInfo info) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return AnnotationInvocationHandler.proxy(info, cl);
        }

        public static <T extends Annotation> T proxy(GeneralAnnoInfo info, ClassLoader cl) {
            AnnotationInvocationHandler<T> handler = new AnnotationInvocationHandler<T>(info, cl);
            return (T)((Annotation)Proxy.newProxyInstance(cl, new Class[]{handler.annotationType()}, handler));
        }
    }

    public static class Visitor
    extends AnnotationVisitor
    implements Opcodes {
        private GeneralAnnoInfo anno;

        public Visitor(AnnotationVisitor av, GeneralAnnoInfo anno) {
            super(327680, av);
            E.NPE((Object)anno);
            this.anno = anno;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AnnotationVisitor av = super.visitAnnotation(name, desc);
            GeneralAnnoInfo annoAnno = this.anno.addAnnotation(name, Type.getType((String)desc));
            return av;
        }

        public void visit(String name, Object value) {
            this.anno.putAttribute(name, value);
            super.visit(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            this.anno.putAttribute(name, new EnumInfo(desc, value));
            super.visitEnum(name, desc, value);
        }

        public AnnotationVisitor visitArray(final String name) {
            AnnotationVisitor av = super.visitArray(name);
            return new AnnotationVisitor(327680, av){

                public void visitEnum(String ignore, String desc, String value) {
                    Visitor.this.anno.putListAttribute(name, new EnumInfo(desc, value));
                }

                public void visit(String ignore, Object value) {
                    Visitor.this.anno.putListAttribute(name, value);
                }
            };
        }
    }

    public static class EnumInfo {
        private Type type;
        private String value;

        EnumInfo(String desc, String value) {
            this.type = Type.getType((String)desc);
            this.value = value;
        }

        public Type type() {
            return this.type;
        }

        public String value() {
            return this.value;
        }
    }
}

