/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.conf.ConfLoader;
import act.util.ClassNames;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.IO;
import org.osgl.util.S;

public enum Jars {

    private static Logger logger = L.get(Jars.class);

    public static Map<String, byte[]> buildClassNameIndex(File dir) {
        return Jars.buildClassNameIndex(dir, (Osgl.Function<String, Boolean>)Osgl.F.FALSE);
    }

    public static Map<String, byte[]> buildClassNameIndex(File dir, Osgl.Function<String, Boolean> ignoredClassNames) {
        C.Map idx = C.newMap((Object[])new Object[0]);
        F.JarEntryVisitor visitor = F.classNameIndexBuilder((Map<String, byte[]>)idx, ignoredClassNames);
        Jars.scanDir(dir, visitor);
        return idx;
    }

    public static Map<String, byte[]> buildClassNameIndex(List<File> jars) {
        return Jars.buildClassNameIndex(jars, (Osgl.Func1<String, Boolean>)Osgl.F.FALSE);
    }

    public static Map<String, byte[]> buildClassNameIndex(List<File> jars, Osgl.Func1<String, Boolean> ignoredClassNames) {
        C.Map idx = C.newMap((Object[])new Object[0]);
        F.JarEntryVisitor visitor = F.classNameIndexBuilder((Map<String, byte[]>)idx, ignoredClassNames);
        Jars.scanList(jars, visitor);
        return idx;
    }

    public static File probeJarFile(Class<?> clazz) {
        String fileName = ClassNames.classNameToClassFileName(clazz.getName());
        URL url = clazz.getClassLoader().getResource(fileName);
        if (null != url && "jar".equals(url.getProtocol())) {
            String path = url.getPath();
            String file = S.str((Object)path).afterFirst("file:").beforeFirst(".jar!").append(".jar").toString();
            return new File(file);
        }
        return null;
    }

    public static void scan(File file, F.JarEntryVisitor ... visitors) {
        if ((file = file.getAbsoluteFile()).isDirectory()) {
            Jars.scanDir(file, visitors);
        } else {
            try {
                Jars.scanFile(file, visitors);
            }
            catch (IOException e) {
                logger.warn((Throwable)e, "Error scanning jar file: %s", new Object[]{file.getName()});
            }
        }
    }

    private static void scanList(List<File> jars, F.JarEntryVisitor visitor) {
        int j = jars.size();
        for (int i = 0; i < j; ++i) {
            File jar = jars.get(i);
            try {
                Jars.scanFile(jar, visitor);
                continue;
            }
            catch (IOException e) {
                logger.warn((Throwable)e, "Error scanning jar file: %s", new Object[]{jar.getName()});
            }
        }
    }

    private static void scanDir(File jarDir, F.JarEntryVisitor ... visitors) {
        for (File file : jarDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            try {
                Jars.scanFile(file, visitors);
            }
            catch (IOException e) {
                logger.warn((Throwable)e, "Error scanning jar file: %s", new Object[]{file.getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFile(File file, F.JarEntryVisitor ... visitors) throws IOException {
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                for (F.JarEntryVisitor visitor : visitors) {
                    if (!name.endsWith(visitor.suffixRequired())) continue;
                    visitor.apply(jar, entry);
                }
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e, "error scan file: %s", new Object[]{file.getAbsolutePath()});
        }
    }

    public static byte[] getBytes(JarFile jar, JarEntry entry) {
        try {
            InputStream is = jar.getInputStream(entry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy((InputStream)is, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public static String readContent(JarFile jar, JarEntry entry) {
        try {
            InputStream is = jar.getInputStream(entry);
            return IO.readContentAsString((InputStream)is);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public static enum F {


        public static JarEntryVisitor classNameIndexBuilder(final Map<String, byte[]> map, final Osgl.Function<String, Boolean> ignoredClassNames) {
            return new JarEntryVisitor(){

                public Void apply(JarFile jarFile, JarEntry entry) throws NotAppliedException, Osgl.Break {
                    String className = ClassNames.classFileNameToClassName(entry.getName());
                    if (!((Boolean)ignoredClassNames.apply((Object)className)).booleanValue()) {
                        map.put(className, Jars.getBytes(jarFile, entry));
                    }
                    return null;
                }
            };
        }

        public static JarEntryVisitor appConfigFileIndexBuilder(final Map<String, Properties> map) {
            return new JarEntryVisitor(){

                @Override
                public String suffixRequired() {
                    return ".properties";
                }

                public Void apply(JarFile jarFile, JarEntry jarEntry) throws NotAppliedException, Osgl.Break {
                    try {
                        String fileName = jarEntry.getName();
                        if (fileName.startsWith("conf/")) {
                            Properties p;
                            FastStr fs = FastStr.of((String)fileName).afterFirst('/');
                            String env = ConfLoader.common();
                            if (fs.contains('/')) {
                                env = fs.beforeFirst('/').intern();
                            }
                            if (null == (p = (Properties)map.get(env))) {
                                p = new Properties();
                                map.put(env, p);
                            }
                            InputStream is = jarFile.getInputStream(jarEntry);
                            Properties p2 = new Properties();
                            p2.load(is);
                            p.putAll((Map<?, ?>)p2);
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e, "Unable to load properties file from jar entry %s", new Object[]{jarEntry.getName()});
                    }
                    return null;
                }
            };
        }

        public static abstract class JarEntryVisitor
        extends Osgl.F2<JarFile, JarEntry, Void> {
            public String suffixRequired() {
                return ".class";
            }
        }
    }
}

