/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.App;
import act.util.DisableFastJsonCircularReferenceDetect;
import act.util.FastJsonIterable;
import act.util.FastJsonIterableSerializer;
import act.util.FastJsonJodaDateCodec;
import act.util.FastJsonKeywordCodec;
import act.util.FastJsonKvCodec;
import act.util.FastJsonSObjectCodec;
import act.util.FastJsonValueObjectSerializer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.mvc.MvcConfig;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.KV;
import org.osgl.util.KVStore;
import org.osgl.util.Keyword;
import org.osgl.util.ValueObject;

public class JsonUtilConfig {
    public static void configure(App app) {
        SerializeConfig config = SerializeConfig.getGlobalInstance();
        config.put(FastJsonIterable.class, (ObjectSerializer)FastJsonIterableSerializer.instance);
        FastJsonJodaDateCodec jodaDateCodec = new FastJsonJodaDateCodec(app);
        app.registerSingleton(FastJsonJodaDateCodec.class, jodaDateCodec);
        FastJsonValueObjectSerializer valueObjectSerializer = new FastJsonValueObjectSerializer();
        app.registerSingleton(FastJsonValueObjectSerializer.class, valueObjectSerializer);
        FastJsonKeywordCodec keywordCodec = new FastJsonKeywordCodec();
        FastJsonSObjectCodec sObjectCodec = new FastJsonSObjectCodec();
        config.put(DateTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalDate.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalDateTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(ValueObject.class, (ObjectSerializer)valueObjectSerializer);
        config.put(Keyword.class, (ObjectSerializer)keywordCodec);
        config.put(KV.class, (ObjectSerializer)FastJsonKvCodec.INSTANCE);
        config.put(KVStore.class, (ObjectSerializer)FastJsonKvCodec.INSTANCE);
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        parserConfig.putDeserializer(DateTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalDate.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalDateTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(Keyword.class, (ObjectDeserializer)keywordCodec);
        parserConfig.putDeserializer(KV.class, (ObjectDeserializer)FastJsonKvCodec.INSTANCE);
        parserConfig.putDeserializer(KVStore.class, (ObjectDeserializer)FastJsonKvCodec.INSTANCE);
        parserConfig.putDeserializer(ISObject.class, (ObjectDeserializer)sObjectCodec);
        parserConfig.putDeserializer(SObject.class, (ObjectDeserializer)sObjectCodec);
        MvcConfig.jsonSerializer((Osgl.Function)new Osgl.F1<Object, String>(){

            public String apply(Object o) throws NotAppliedException, Osgl.Break {
                if (null == o) {
                    return "{}";
                }
                Boolean b = DisableFastJsonCircularReferenceDetect.option.get();
                if (null != b && b.booleanValue()) {
                    return JSON.toJSONString((Object)o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
                }
                return JSON.toJSONString((Object)o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
            }
        });
    }
}

