/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.ActionContext;
import act.cli.CliContext;
import act.controller.meta.HandlerMethodMetaInfo;
import act.util.ActContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.METHOD})
public @interface PropertySpec {
    public static final ThreadLocal<String> current = new ThreadLocal();

    public String[] value() default {};

    public String[] cli() default {};

    public String[] http() default {};

    public static class MetaInfo {
        private static Pattern p = Pattern.compile("\\s+as\\s+", 2);
        private Spec common = MetaInfo.newSpec();
        private Spec cli = MetaInfo.newSpec();
        private Spec http = MetaInfo.newSpec();

        private static Spec newSpec() {
            return new Spec();
        }

        public void onValue(String value) {
            this._on(value, this.common);
        }

        public void onCli(String value) {
            this._on(value, this.cli);
        }

        public void onHttp(String value) {
            this._on(value, this.http);
        }

        public void ensureValid() {
            if (this.common.isEmpty() && this.http.isEmpty() && this.cli.isEmpty()) {
                throw new IllegalStateException("no spec defined");
            }
        }

        private void _on(String string, Spec spec) {
            String[] sa;
            for (String s : sa = string.split("[,;:]+")) {
                if ((s = s.trim()).startsWith("-")) {
                    spec.excluded().add(s.substring(1));
                    spec.outputs().clear();
                    continue;
                }
                String[] sa0 = p.split(s);
                if (sa0.length > 1) {
                    String k = sa0[0].trim();
                    String v = sa0[1].trim();
                    spec.labels().put(k, v);
                    if (!spec.excluded().isEmpty()) continue;
                    spec.outputs().add(k);
                    continue;
                }
                if (!spec.excluded().isEmpty()) continue;
                spec.outputs().add(s.trim());
            }
        }

        @Deprecated
        public List<String> outputFields() {
            return C.list(this.common.outputs());
        }

        public List<String> outputFields(ActContext context) {
            Spec spec = this.spec(context);
            return null == spec ? C.list() : spec.outputs();
        }

        public List<String> labels(List<String> outputs, ActContext context) {
            C.List retList = C.newList();
            for (String f2 : outputs) {
                retList.add(this.label(f2, context));
            }
            return retList;
        }

        public Map<String, String> labelMapping() {
            return C.map(this.common.labels());
        }

        public Map<String, String> labelMapping(ActContext context) {
            return C.map(this.spec(context).labels());
        }

        public Set<String> excludedFields(ActContext context) {
            return C.set(this.spec(context).excluded());
        }

        public String label(String field, ActContext context) {
            String lbl = this.spec(context).labels().get(field);
            return null == lbl ? field : lbl;
        }

        private Spec spec(ActContext context) {
            if (context instanceof ActionContext) {
                return null == this.http || this.http.isEmpty() ? this.common : this.http;
            }
            if (context instanceof CliContext) {
                return null == this.cli || this.cli.isEmpty() ? this.common : this.cli;
            }
            throw new IllegalStateException("context not applied: " + context);
        }

        public static MetaInfo withCurrent(MetaInfo builtIn, ActContext context) {
            String s = current.get();
            if (S.notBlank((String)s)) {
                MetaInfo spec = new MetaInfo();
                if (context instanceof CliContext) {
                    spec.onCli(s);
                } else {
                    spec.onHttp(s);
                }
                return spec;
            }
            return builtIn;
        }

        public static MetaInfo withCurrent(HandlerMethodMetaInfo methodMetaInfo, ActContext context) {
            MetaInfo builtIn = null == methodMetaInfo ? null : methodMetaInfo.propertySpec();
            return MetaInfo.withCurrent(builtIn, context);
        }

        static class Spec
        extends Osgl.T3<List<String>, Set<String>, Map<String, String>> {
            Spec() {
                super((Object)C.newList(), (Object)C.newSet(), (Object)C.newMap((Object[])new Object[0]));
            }

            List<String> outputs() {
                return (List)this._1;
            }

            Set<String> excluded() {
                return (Set)this._2;
            }

            Map<String, String> labels() {
                return (Map)this._3;
            }

            boolean isEmpty() {
                return ((List)this._1).isEmpty() && ((Set)this._2).isEmpty() && ((Map)this._3).isEmpty();
            }
        }
    }
}

