/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.conf.AppConfig;
import act.plugin.Plugin;
import act.util.DestroyableBase;
import act.util.SessionMapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.Charsets;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;

public class SessionManager
extends DestroyableBase {
    private static Logger logger = L.get(SessionManager.class);
    private C.List<Listener> registry = C.newList();
    private Map<App, CookieResolver> resolvers = C.newMap((Object[])new Object[0]);
    private CookieResolver theResolver = null;

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.registry, ApplicationScoped.class);
        this.registry = null;
        Destroyable.Util.tryDestroyAll(this.resolvers.values(), ApplicationScoped.class);
        this.resolvers = null;
        this.theResolver = null;
    }

    public void register(Listener listener) {
        if (!this.registry.contains((Object)listener)) {
            this.registry.add((Object)listener);
        }
    }

    public <T extends Listener> T findListener(Class<T> clz) {
        for (Listener l : this.registry) {
            if (!clz.isAssignableFrom(l.getClass())) continue;
            return (T)l;
        }
        return null;
    }

    public H.Session resolveSession(ActionContext context) {
        H.Session session = this.getResolver(context).resolveSession(context);
        return session;
    }

    public void fireSessionResolved(ActionContext ctx) {
        this.sessionResolved(ctx.session(), ctx);
    }

    public H.Flash resolveFlash(ActionContext context) {
        return this.getResolver(context).resolveFlash(context);
    }

    public H.Cookie dissolveSession(ActionContext context) {
        this.onSessionDissolve();
        return this.getResolver(context).dissolveSession(context);
    }

    public H.Cookie dissolveFlash(ActionContext context) {
        return this.getResolver(context).dissolveFlash(context);
    }

    private void sessionResolved(H.Session session, ActionContext context) {
        for (Listener l : this.registry) {
            l.sessionResolved(session, context);
        }
    }

    private void onSessionDissolve() {
        for (Listener l : this.registry) {
            l.onSessionDissolve();
        }
    }

    private CookieResolver getResolver(ActionContext context) {
        App app = context.app();
        if (Act.multiTenant()) {
            CookieResolver resolver = this.resolvers.get(app);
            if (null == resolver) {
                resolver = new CookieResolver(app);
                this.resolvers.put(app, resolver);
            }
            return resolver;
        }
        if (this.theResolver == null) {
            this.theResolver = new CookieResolver(app);
        }
        return this.theResolver;
    }

    static class CookieResolver {
        private App app;
        private AppConfig conf;
        private boolean encryptSession;
        private boolean persistentSession;
        private boolean sessionSecure;
        private long ttl;
        private boolean sessionWillExpire;
        private SessionMapper sessionMapper;
        private String sessionCookieName;
        private String flashCookieName;

        CookieResolver(App app) {
            E.NPE((Object)app);
            this.app = app;
            this.conf = app.config();
            this.encryptSession = this.conf.encryptSession();
            this.persistentSession = this.conf.persistSession();
            this.sessionSecure = this.conf.sessionSecure();
            long ttl = this.conf.sessionTtl();
            this.ttl = ttl * 1000L;
            this.sessionWillExpire = ttl > 0L;
            this.sessionMapper = this.conf.sessionMapper();
            this.sessionCookieName = this.conf.sessionCookieName();
            this.flashCookieName = this.conf.flashCookieName();
        }

        H.Session resolveSession(ActionContext context) {
            H.Request req = context.req();
            context.preCheckCsrf();
            String val = this.sessionMapper.deserializeSession(context);
            H.Session session = new H.Session();
            long now = $.ms();
            if (S.blank((String)val)) {
                session = this.processExpiration(session, now, true, req);
            } else {
                this.resolveFromCookieContent((H.KV<?>)session, val, true);
                session = this.processExpiration(session, now, false, req);
            }
            context.checkCsrf(session);
            return session;
        }

        H.Flash resolveFlash(ActionContext context) {
            H.Flash flash = new H.Flash();
            String val = this.sessionMapper.deserializeFlash(context);
            if (null != val) {
                this.resolveFromCookieContent((H.KV<?>)flash, val, false);
                flash.discard();
            }
            return flash;
        }

        H.Cookie dissolveSession(ActionContext context) {
            H.Cookie cookie;
            context.setCsrfCookieAndRenderArgs();
            H.Session session = context.session();
            if (null == session) {
                return null;
            }
            boolean sessionChanged = session.changed();
            if (!(sessionChanged || !session.empty() && this.sessionWillExpire)) {
                return null;
            }
            if (session.empty()) {
                cookie = this.createCookie(this.sessionCookieName, "");
            } else {
                session.id();
                if (this.sessionWillExpire && !session.contains("___TS")) {
                    session.put("___TS", (Object)($.ms() + this.ttl));
                }
                String data = this.dissolveIntoCookieContent((H.KV<?>)session, true);
                cookie = this.createCookie(this.sessionCookieName, data);
            }
            return cookie;
        }

        H.Cookie dissolveFlash(ActionContext context) {
            H.Flash flash = context.flash();
            if (null == flash || flash.isEmpty()) {
                return null;
            }
            String data = this.dissolveIntoCookieContent(flash.out(), false);
            H.Cookie cookie = this.createCookie(this.flashCookieName, data);
            return cookie;
        }

        void resolveFromCookieContent(H.KV<?> kv, String content, boolean isSession) {
            List<char[]> pairs;
            String data = Codec.decodeUrl((String)content, (Charset)Charsets.UTF_8);
            if (isSession) {
                String sign1;
                int firstDashIndex;
                if (this.encryptSession) {
                    try {
                        data = this.app.decrypt(data);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                if ((firstDashIndex = data.indexOf("-")) < 0) {
                    return;
                }
                String sign = data.substring(0, firstDashIndex);
                if (!sign.equals(sign1 = this.app.sign(data = data.substring(firstDashIndex + 1)))) {
                    return;
                }
            }
            if ((pairs = this.split(data.toCharArray(), '\u0000')).isEmpty()) {
                return;
            }
            for (char[] pair : pairs) {
                List<char[]> kAndV = this.split(pair, '\u0001');
                int sz = kAndV.size();
                if (sz != 2) {
                    S.Buffer sb = S.newBuffer();
                    for (int i = 0; i < sz; ++i) {
                        if (i > 0) {
                            sb.append(":");
                        }
                        sb.append(Arrays.toString(kAndV.get(i)));
                    }
                    logger.warn("unexpected KV string: %S", new Object[]{sb.toString()});
                    continue;
                }
                kv.put(new String(kAndV.get(0)), new String(kAndV.get(1)));
            }
        }

        private List<char[]> split(char[] content, char separator) {
            int len = content.length;
            if (0 == len) {
                return C.list();
            }
            ArrayList<char[]> l = new ArrayList<char[]>();
            int start = 0;
            for (int i = 0; i < len; ++i) {
                char c = content[i];
                if (c != separator) continue;
                if (i == start) {
                    ++start;
                    continue;
                }
                char[] ca = new char[i - start];
                System.arraycopy(content, start, ca, 0, i - start);
                l.add(ca);
                start = i + 1;
            }
            if (start == 0) {
                l.add(content);
            } else {
                char[] ca = new char[len - start];
                System.arraycopy(content, start, ca, 0, len - start);
                l.add(ca);
            }
            return l;
        }

        String dissolveIntoCookieContent(H.KV<?> kv, boolean isSession) {
            S.Buffer sb = S.buffer();
            int i = 0;
            for (String k : kv.keySet()) {
                if (i > 0) {
                    sb.append("\u0000");
                }
                sb.append(k);
                sb.append("\u0001");
                sb.append(kv.get(k));
                ++i;
            }
            String data = sb.toString();
            if (isSession) {
                String sign = this.app.sign(data);
                data = S.concat((String)sign, (String)"-", (String)data);
                if (this.encryptSession) {
                    data = this.app.encrypt(data);
                }
            }
            data = Codec.encodeUrl((String)data, (Charset)Charsets.UTF_8);
            return data;
        }

        private H.Session processExpiration(H.Session session, long now, boolean freshSession, H.Request request) {
            if (!this.sessionWillExpire) {
                return session;
            }
            long expiration = now + this.ttl;
            if (freshSession) {
                session.load("___TS", String.valueOf(expiration));
            } else {
                String s = session.get("___TS");
                long oldTimestamp = null == s ? -1L : Long.parseLong(s);
                long newTimestamp = expiration;
                if (oldTimestamp < 0L) {
                    session = new H.Session();
                } else if (oldTimestamp < now) {
                    session = new H.Session();
                    session.put("___expired", (Object)true);
                } else {
                    session.remove("___expired");
                    boolean skipUpdateExpiration = S.eq((String)this.conf.pingPath(), (String)request.url());
                    if (skipUpdateExpiration) {
                        newTimestamp = oldTimestamp;
                    }
                }
                session.put("___TS", (Object)newTimestamp);
            }
            return session;
        }

        private H.Cookie createCookie(String name, String value) {
            H.Cookie cookie = new H.Cookie(name, value);
            cookie.path("/");
            cookie.domain(this.conf.cookieDomain());
            cookie.httpOnly(true);
            cookie.secure(this.sessionSecure);
            if (this.sessionWillExpire && this.persistentSession) {
                cookie.maxAge((int)(this.ttl / 1000L));
            }
            return cookie;
        }
    }

    public static abstract class Listener
    extends DestroyableBase
    implements Plugin {
        @Override
        public void register() {
            Act.sessionManager().register(this);
        }

        public void sessionResolved(H.Session session, ActionContext context) {
        }

        public void onSessionDissolve() {
        }
    }
}

