/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.util.AppByteCodeEnhancer;
import act.util.SingletonBase;
import javax.inject.Singleton;
import org.osgl.Osgl;
import org.osgl.util.S;

public class SingletonEnhancer
extends AppByteCodeEnhancer<SingletonEnhancer> {
    private boolean shouldEnhance = false;
    private boolean shouldAddAnnotation = true;
    private String typeName;

    public SingletonEnhancer() {
        super((Osgl.Predicate<String>)Osgl.F.yes());
    }

    @Override
    protected Class<SingletonEnhancer> subClass() {
        return SingletonEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.typeName = name;
        if (SingletonBase.class.getName().equals(Type.getObjectType((String)superName).getClassName())) {
            if (SingletonEnhancer.isAbstract(access)) {
                logger.warn("SingletonBase sub class is abstract: %s", new Object[]{name});
                return;
            }
            if (!SingletonEnhancer.isPublic(access)) {
                logger.warn("SingletonBase sub class is not public: %s", new Object[]{name});
                return;
            }
            this.shouldEnhance = true;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type type = Type.getType((String)desc);
        if (Singleton.class.getName().equals(type.getClassName())) {
            this.shouldAddAnnotation = false;
            this.shouldEnhance = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (this.shouldEnhance) {
            this.addAnnotationIfNeeded();
            this.addInstanceMethod();
        }
        super.visitEnd();
    }

    private void addAnnotationIfNeeded() {
        if (this.shouldAddAnnotation) {
            AnnotationVisitor av = super.visitAnnotation(Type.getType(Singleton.class).getDescriptor(), true);
            av.visitEnd();
        }
    }

    private void addInstanceMethod() {
        MethodVisitor mv = super.visitMethod(9, "instance", "()Ljava/lang/Object;", "<T:Ljava/lang/Object;>()TT;", null);
        mv.visitCode();
        mv.visitMethodInsn(184, "act/app/App", "instance", "()Lact/app/App;", false);
        mv.visitLdcInsn((Object)Type.getType((String)this.instanceTypeDesc()));
        mv.visitMethodInsn(182, "act/app/App", "singleton", "(Ljava/lang/Class;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
    }

    private String instanceMethodReturnTypeDesc() {
        return S.fmt((String)"()L%s;", (Object[])new Object[]{this.typeName});
    }

    private String instanceTypeDesc() {
        return S.fmt((String)"L%s;", (Object[])new Object[]{this.typeName});
    }
}

