/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.ActionContext;
import act.app.App;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.controller.FastRequestHandler;
import act.util.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.osgl.http.H;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.KeyGenerator;
import org.osgl.storage.impl.FileSystemService;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class UploadFileStorageService
extends FileSystemService {
    public UploadFileStorageService(Map<String, String> conf) {
        super(conf);
    }

    public static IStorageService create(App app) {
        File tmp = app.tmpDir();
        if (!tmp.exists() && !tmp.mkdirs()) {
            throw E.unexpected((String)"Cannot create tmp dir", (Object[])new Object[0]);
        }
        C.Map conf = C.newMap((Object[])new Object[]{"storage.fs.home.dir", Files.file(app.tmpDir(), "uploads").getAbsolutePath(), "storage.keygen", KeyGenerator.BY_DATE.name()});
        conf.put("storage.id", "__upload");
        return new UploadFileStorageService((Map<String, String>)conf);
    }

    public static ISObject store(FileItem file, App app) {
        IStorageService ss = app.uploadFileStorageService();
        try {
            String key = UploadFileStorageService.newKey();
            SObject sobj = SObject.of((InputStream)file.getInputStream());
            sobj.setAttribute("filename", file.getName());
            sobj.setAttribute("content-type", file.getContentType());
            sobj.setAttribute("url", "/~upload/" + sobj.getKey());
            ss.put(key, (ISObject)sobj);
            return ss.get(key);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public static String newKey() {
        return UUID.randomUUID().toString();
    }

    public static class UploadFileGetter
    extends FastRequestHandler {
        @Override
        public void handle(ActionContext context) {
            String key = context.paramVal("path");
            if (S.blank((String)key)) {
                AlwaysNotFound.INSTANCE.handle(context);
                return;
            }
            ISObject sobj = context.app().uploadFileStorageService().get(key);
            if (null == sobj) {
                AlwaysNotFound.INSTANCE.handle(context);
                return;
            }
            H.Format fmt = H.Format.of((String)sobj.getAttribute("content-type"));
            BufferedInputStream is = new BufferedInputStream(sobj.asInputStream());
            H.Response resp = context.resp();
            if (null != fmt && H.Format.UNKNOWN != fmt) {
                resp.contentType(fmt.contentType());
            }
            IO.copy((InputStream)is, (OutputStream)context.resp().outputStream());
        }

        public String toString() {
            return "Upload file getter";
        }
    }
}

