/*
 * Decompiled with CFR 0.152.
 */
package act.validation;

import act.conf.AppConfig;
import act.i18n.I18n;
import act.util.DestroyableBase;
import java.util.Locale;
import javax.validation.MessageInterpolator;
import org.osgl.util.S;

public class ActValidationMessageInterpolator
extends DestroyableBase
implements MessageInterpolator {
    private MessageInterpolator realInterpolator;
    private AppConfig config;

    public ActValidationMessageInterpolator(MessageInterpolator defaultInterpolator, AppConfig config) {
        this.realInterpolator = defaultInterpolator;
        this.config = config;
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.interpolate(messageTemplate, context, I18n.locale());
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        if (messageTemplate.startsWith("{act.")) {
            return this.actInterpolate(messageTemplate, locale);
        }
        if (!messageTemplate.startsWith("{")) {
            messageTemplate = S.concat((String)"{", (String)messageTemplate, (String)"}");
        }
        return this.realInterpolator.interpolate(messageTemplate, context, locale);
    }

    private String actInterpolate(String messageTemplate, Locale locale) {
        if (null == locale) {
            locale = I18n.locale();
        }
        return I18n.i18n(locale, "act_message", messageTemplate, new Object[0]);
    }
}

