/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.BadRequest;

public class ActBadRequest
extends BadRequest
implements ActError {
    private SourceInfo sourceInfo;

    public ActBadRequest() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActBadRequest(String message, Object ... args) {
        super(message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActBadRequest(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActBadRequest(Throwable cause) {
        super(cause);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActBadRequest.class);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = super.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActBadRequest root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static BadRequest create() {
        return Act.isDev() ? new ActBadRequest() : BadRequest.get();
    }

    public static BadRequest create(String msg, Object ... args) {
        return Act.isDev() ? new ActBadRequest(msg, args) : BadRequest.of((String)msg, (Object[])args);
    }

    public static BadRequest create(Throwable cause, String msg, Object ... args) {
        return Act.isDev() ? new ActBadRequest(cause, msg, args) : new BadRequest(cause, msg, args);
    }

    public static BadRequest create(Throwable cause) {
        return Act.isDev() ? new ActBadRequest(cause) : new BadRequest(cause);
    }
}

