/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.Conflict;

public class ActConflict
extends Conflict
implements ActError {
    private SourceInfo sourceInfo;

    public ActConflict() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActConflict(String message, Object ... args) {
        super(message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActConflict(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActConflict(Throwable cause) {
        super(cause);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActConflict.class);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = super.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActConflict root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static Conflict create() {
        return Act.isDev() ? new ActConflict() : Conflict.get();
    }

    public static Conflict create(String msg, Object ... args) {
        return Act.isDev() ? new ActConflict(msg, args) : Conflict.of((String)msg, (Object[])args);
    }

    public static Conflict create(Throwable cause, String msg, Object ... args) {
        return Act.isDev() ? new ActConflict(cause, msg, args) : Conflict.of((Throwable)cause, (String)msg, (Object[])args);
    }

    public static Conflict create(Throwable cause) {
        return Act.isDev() ? new ActConflict(cause) : Conflict.of((Throwable)cause);
    }
}

