/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.App;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.app.SourceInfo;
import act.app.SourceInfoImpl;
import act.exception.BindException;
import act.util.ActError;
import act.view.ActBadRequest;
import act.view.ActConflict;
import act.view.ActForbidden;
import act.view.ActMethodNotAllowed;
import act.view.ActNotFound;
import act.view.ActNotImplemented;
import act.view.ActUnauthorized;
import act.view.RythmTemplateException;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.osgl.Osgl;
import org.osgl.exception.InvalidRangeException;
import org.osgl.exception.UnsupportedException;
import org.osgl.http.H;
import org.osgl.mvc.annotation.ResponseStatus;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.rythmengine.exception.RythmException;

public class ActErrorResult
extends ErrorResult
implements ActError {
    protected SourceInfo sourceInfo;
    private static Map<Class<? extends Throwable>, Osgl.Function<Throwable, Result>> x = C.newMap((Object[])new Object[0]);
    private static Map<Class, Integer> userDefinedStatus;

    public ActErrorResult(H.Status status) {
        super(status);
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, String message, Object ... args) {
        super(status, message, args);
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, int errorCode) {
        super(status, Integer.valueOf(errorCode));
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(H.Status status, int errorCode, String message, Object ... args) {
        super(status, Integer.valueOf(errorCode), message, args);
        this.init();
        this.populateSourceInfo();
    }

    public ActErrorResult(Throwable cause) {
        super(H.Status.INTERNAL_SERVER_ERROR, cause);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, Throwable cause) {
        super(status, cause);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, Throwable cause, String message, Object ... args) {
        super(status, cause, message, args);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, int errorCode, Throwable cause, String message, Object ... args) {
        super(status, Integer.valueOf(errorCode), cause, message, args);
        this.init();
        this.populateSourceInfo(cause);
    }

    public ActErrorResult(H.Status status, int errorCode, Throwable cause) {
        super(status, Integer.valueOf(errorCode), cause);
        this.init();
        this.populateSourceInfo(cause);
    }

    @Override
    public Throwable getCauseOrThis() {
        return ActErrorResult.rootCauseOf((Throwable)((Object)this));
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    public int statusCode() {
        Throwable cause = super.getCause();
        int statusCode = null == cause ? -1 : ActErrorResult.userDefinedStatusCode(cause.getClass());
        return -1 == statusCode ? super.statusCode() : statusCode;
    }

    @Override
    public List<String> stackTrace() {
        C.List l = C.newList();
        Throwable t = this.getCauseOrThis();
        while (null != t) {
            StackTraceElement[] a;
            for (StackTraceElement e : a = t.getStackTrace()) {
                l.add("at " + e.toString());
            }
            if (null == (t = t.getCause())) continue;
            l.add("Caused by " + t.toString());
        }
        return l;
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    protected void init() {
    }

    protected void populateSourceInfo(Throwable t) {
        if (!Act.isDev()) {
            return;
        }
        if (t instanceof SourceInfo) {
            this.sourceInfo = (SourceInfo)((Object)t);
        } else {
            DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
            for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                Source source;
                int line = stackTraceElement.getLineNumber();
                if (line <= 0 || null == (source = cl.source(stackTraceElement.getClassName()))) continue;
                this.sourceInfo = new SourceInfoImpl(source, line);
            }
        }
    }

    private void populateSourceInfo() {
        this.populateSourceInfo(new RuntimeException());
    }

    private static int userDefinedStatusCode(Class<? extends Throwable> exCls) {
        Integer I = userDefinedStatus.get(exCls);
        if (null == I) {
            ResponseStatus rs = exCls.getAnnotation(ResponseStatus.class);
            if (null == rs) {
                I = -1;
                userDefinedStatus.put(exCls, -1);
            } else {
                I = rs.value();
            }
        }
        return I;
    }

    public static Result of(Throwable t) {
        if (t instanceof Result) {
            return (Result)t;
        }
        if (t instanceof RythmException) {
            return Act.isDev() ? new RythmTemplateException((RythmException)t) : ErrorResult.of((H.Status)H.Status.INTERNAL_SERVER_ERROR);
        }
        Osgl.Function<Throwable, Result> transformer = ActErrorResult.transformerOf(t);
        return null == transformer ? new ActErrorResult(t) : (Result)((Object)transformer.apply((Object)t));
    }

    private static Osgl.Function<Throwable, Result> transformerOf(Throwable t) {
        Class<?> tc = t.getClass();
        Osgl.Function<Throwable, Result> transformer = x.get(tc);
        if (null != transformer) {
            return transformer;
        }
        for (Class<? extends Throwable> c : x.keySet()) {
            if (!c.isAssignableFrom(tc)) continue;
            return x.get(c);
        }
        return null;
    }

    public static Result ofStatus(int statusCode) {
        return ActErrorResult.of(H.Status.of((int)statusCode));
    }

    @Deprecated
    public static Result of(int statusCode) {
        E.illegalArgumentIf((statusCode < 400 ? 1 : 0) != 0);
        switch (statusCode) {
            case 400: {
                return ActBadRequest.create();
            }
            case 401: {
                return ActUnauthorized.create();
            }
            case 403: {
                return ActForbidden.create();
            }
            case 404: {
                return ActNotFound.create();
            }
            case 405: {
                return ActMethodNotAllowed.create();
            }
            case 409: {
                return ActConflict.create();
            }
            case 501: {
                return ActNotImplemented.create();
            }
        }
        if (Act.isDev()) {
            return new ActErrorResult(new RuntimeException());
        }
        return new ErrorResult(H.Status.of((int)statusCode));
    }

    public static ErrorResult of(H.Status status) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status);
        }
        return ErrorResult.of((H.Status)status);
    }

    public static ErrorResult of(H.Status status, String message, Object ... args) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, message, args);
        }
        return ErrorResult.of((H.Status)status, (String)message, (Object[])args);
    }

    public static ErrorResult of(H.Status status, int errorCode) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, errorCode);
        }
        return ErrorResult.of((H.Status)status, (int)errorCode);
    }

    public static ErrorResult of(H.Status status, int errorCode, String message, Object ... args) {
        E.illegalArgumentIf((!status.isClientError() && !status.isServerError() ? 1 : 0) != 0);
        if (Act.isDev()) {
            return new ActErrorResult(status, errorCode, message, args);
        }
        return ErrorResult.of((H.Status)status, (int)errorCode, (String)message, (Object[])args);
    }

    public static Throwable rootCauseOf(Throwable t) {
        Throwable cause;
        if (null == t) {
            return null;
        }
        while (null != (cause = t.getCause())) {
            t = cause;
        }
        return t;
    }

    static {
        Osgl.Transformer<Throwable, Result> unsupported = new Osgl.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActNotImplemented.create(throwable);
            }
        };
        x.put(UnsupportedException.class, (Osgl.Function<Throwable, Result>)unsupported);
        x.put(UnsupportedOperationException.class, (Osgl.Function<Throwable, Result>)unsupported);
        x.put(IllegalStateException.class, (Osgl.Function<Throwable, Result>)new Osgl.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActConflict.create(throwable);
            }
        });
        Osgl.Transformer<Throwable, Result> badRequest = new Osgl.Transformer<Throwable, Result>(){

            public Result transform(Throwable throwable) {
                return ActBadRequest.create(throwable);
            }
        };
        x.put(IllegalArgumentException.class, (Osgl.Function<Throwable, Result>)badRequest);
        x.put(InvalidRangeException.class, (Osgl.Function<Throwable, Result>)badRequest);
        x.put(IndexOutOfBoundsException.class, (Osgl.Function<Throwable, Result>)badRequest);
        x.put(ValidationException.class, (Osgl.Function<Throwable, Result>)badRequest);
        x.put(BindException.class, (Osgl.Function<Throwable, Result>)badRequest);
        userDefinedStatus = C.newMap((Object[])new Object[0]);
    }
}

