/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.Forbidden;

public class ActForbidden
extends Forbidden
implements ActError {
    private SourceInfo sourceInfo;

    public ActForbidden() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActForbidden(String message, Object ... args) {
        super(message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActForbidden(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActForbidden(Throwable cause) {
        super(cause);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActForbidden.class);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = super.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActForbidden root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static Forbidden create() {
        return Act.isDev() ? new ActForbidden() : Forbidden.get();
    }

    public static Forbidden create(String msg, Object ... args) {
        return Act.isDev() ? new ActForbidden(msg, args) : Forbidden.of((String)msg, (Object[])args);
    }

    public static Forbidden create(Throwable cause, String msg, Object ... args) {
        return Act.isDev() ? new ActForbidden(cause, msg, args) : Forbidden.of((Throwable)cause, (String)msg, (Object[])args);
    }

    public static Forbidden create(Throwable cause) {
        return Act.isDev() ? new ActForbidden(cause) : Forbidden.of((Throwable)cause);
    }
}

