/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.MethodNotAllowed;

public class ActMethodNotAllowed
extends MethodNotAllowed
implements ActError {
    private SourceInfo sourceInfo;

    public ActMethodNotAllowed() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActMethodNotAllowed(String message, Object ... args) {
        super(message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActMethodNotAllowed(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActMethodNotAllowed(Throwable cause) {
        super(cause);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActMethodNotAllowed.class);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = super.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActMethodNotAllowed root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static MethodNotAllowed create() {
        return Act.isDev() ? new ActMethodNotAllowed() : MethodNotAllowed.get();
    }

    public static MethodNotAllowed create(String msg, Object ... args) {
        return Act.isDev() ? new ActMethodNotAllowed(msg, args) : MethodNotAllowed.of((String)msg, (Object[])args);
    }

    public static MethodNotAllowed create(Throwable cause, String msg, Object ... args) {
        return Act.isDev() ? new ActMethodNotAllowed(cause, msg, args) : MethodNotAllowed.of((Throwable)cause, (String)msg, (Object[])args);
    }

    public static MethodNotAllowed create(Throwable cause) {
        return Act.isDev() ? new ActMethodNotAllowed(cause) : MethodNotAllowed.of((Throwable)cause);
    }
}

