/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.lang.reflect.Method;
import java.util.List;
import org.osgl.mvc.result.NotFound;

public class ActNotFound
extends NotFound
implements ActError {
    private SourceInfo sourceInfo;

    public ActNotFound() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActNotFound(String message, Object ... args) {
        super(message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActNotFound(Method method) {
        super("null value returned from %s.%s()", new Object[]{method.getDeclaringClass().getName(), method.getName()});
        if (Act.isDev()) {
            this.loadSourceInfo(method);
        }
    }

    public ActNotFound(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActNotFound(Throwable cause) {
        super(cause);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActNotFound.class);
    }

    private void loadSourceInfo(Method method) {
        this.sourceInfo = ActError.Util.loadSourceInfo(method);
    }

    @Override
    public Throwable getCauseOrThis() {
        Throwable cause = super.getCause();
        return null == cause ? this : cause;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActNotFound root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static NotFound create() {
        return Act.isDev() ? new ActNotFound() : NotFound.get();
    }

    public static NotFound create(String msg, Object ... args) {
        return Act.isDev() ? new ActNotFound(msg, args) : NotFound.of((String)msg, (Object[])args);
    }

    public static NotFound create(Method method) {
        return Act.isDev() ? new ActNotFound(method) : NotFound.get();
    }

    public static NotFound create(Throwable cause, String msg, Object ... args) {
        return Act.isDev() ? new ActNotFound(cause, msg, args) : NotFound.of((Throwable)cause, (String)msg, (Object[])args);
    }

    public static NotFound create(Throwable cause) {
        return Act.isDev() ? new ActNotFound(cause) : NotFound.of((Throwable)cause);
    }
}

