/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.Unauthorized;

public class ActUnauthorized
extends Unauthorized
implements ActError {
    private SourceInfo sourceInfo;

    public ActUnauthorized() {
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActUnauthorized(String realm) {
        super(realm);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    public ActUnauthorized(String realm, boolean digest) {
        super(realm, digest);
        if (Act.isDev()) {
            this.loadSourceInfo();
        }
    }

    private void loadSourceInfo() {
        this.doFillInStackTrace();
        Throwable cause = this.getCause();
        this.sourceInfo = ActError.Util.loadSourceInfo(null == cause ? this.getStackTrace() : cause.getStackTrace(), ActUnauthorized.class);
    }

    @Override
    public Throwable getCauseOrThis() {
        return this;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public List<String> stackTrace() {
        Object cause = this.getCause();
        ActUnauthorized root = this;
        if (null == cause) {
            cause = this;
            root = null;
        }
        return ActError.Util.stackTraceOf((Throwable)cause, root);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static Unauthorized create() {
        return Act.isDev() ? new ActUnauthorized() : Unauthorized.get();
    }

    public static Unauthorized create(String realm) {
        return Act.isDev() ? new ActUnauthorized(realm) : Unauthorized.of((String)realm);
    }

    public static Unauthorized create(String realm, boolean digest) {
        return Act.isDev() ? new ActUnauthorized(realm, digest) : new Unauthorized(realm, digest);
    }
}

