/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.ActionContext;
import act.exception.ActException;
import act.view.RenderAny;
import act.view.Template;
import act.view.ViewManager;
import java.util.Map;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.S;

public class RenderTemplate
extends RenderAny {
    public static RenderTemplate INSTANCE = new RenderTemplate(){

        public H.Status status() {
            H.Status status = this.payload().status;
            return null == status ? super.status() : status;
        }
    };
    static final ThreadLocal<Map<String, Object>> renderArgsBag = new ThreadLocal();

    private RenderTemplate() {
    }

    @Override
    public void apply(H.Request req, H.Response resp) {
        renderArgsBag.remove();
        throw E.unsupport((String)"RenderTemplate does not support apply to request and response. Please use apply(AppContext) instead", (Object[])new Object[0]);
    }

    @Override
    public void apply(ActionContext context) {
        ViewManager vm;
        Template t;
        Map<String, Object> renderArgs = renderArgsBag.get();
        if (null != renderArgs && !renderArgs.isEmpty()) {
            for (String key : renderArgs.keySet()) {
                context.renderArg(key, renderArgs.get(key));
            }
        }
        if (null == (t = (vm = Act.viewManager()).load(context))) {
            throw new ActException("Render template[%s] not found", context.templatePath());
        }
        this.applyStatus(context.resp());
        H.Request req = context.req();
        H.Response resp = context.resp();
        this.setContentType(req, resp);
        this.applyBeforeCommitHandler(req, resp);
        t.merge(context);
        this.applyAfterCommitHandler(req, resp);
    }

    protected void setContentType(H.Request req, H.Response resp) {
        String s = req.accept().contentType();
        String encoding = resp.characterEncoding();
        if (S.notBlank((String)encoding)) {
            s = S.concat((String)s, (String)"; charset=", (String)encoding.toLowerCase());
        }
        resp.initContentType(s);
    }

    public static RenderTemplate get() {
        return INSTANCE;
    }

    public static RenderTemplate get(H.Status status) {
        ((Result.Payload)payload.get()).status(status);
        return INSTANCE;
    }

    public static RenderTemplate of(Map<String, Object> args) {
        renderArgsBag.set(args);
        return INSTANCE;
    }

    public static RenderTemplate of(H.Status status, Map<String, Object> args) {
        ((Result.Payload)payload.get()).status(status);
        renderArgsBag.set(args);
        return INSTANCE;
    }
}

