/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.util.ActContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class TemplatePathResolver {
    private static final Set<H.Format> supportedFormats = new HashSet<H.Format>();

    public final String resolve(ActContext context) {
        String path = context.templatePath();
        return this.resolveTemplatePath(path, context);
    }

    public final String resolveWithContextMethodPath(ActContext context) {
        S.Buffer sb;
        String methodPath = context.methodPath();
        String path = context.templatePath();
        String[] sa = path.split("\\.");
        int level = sa.length + 1;
        if (S.notBlank((String)methodPath)) {
            while (--level > 0) {
                methodPath = S.beforeLast((String)methodPath, (String)".");
            }
            sb = S.newBuffer((String)methodPath);
        } else {
            sb = S.newBuffer();
        }
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        path = sb.append(path).toString().replace('.', '/');
        return this.resolveTemplatePath(path, context);
    }

    protected String resolveTemplatePath(String path, ActContext context) {
        return this.amendSuffix(path, context);
    }

    protected String amendSuffix(String path, ActContext context) {
        if (path.contains(".")) {
            return path;
        }
        H.Format fmt = context.accept();
        if (H.Format.UNKNOWN == fmt) {
            fmt = H.Format.HTML;
        }
        if (TemplatePathResolver.isAcceptFormatSupported(fmt)) {
            return S.concat((String)path, (String)".", (String)fmt.name());
        }
        throw E.unsupport((String)"Request accept not supported: %s", (Object[])new Object[]{fmt});
    }

    public static void registerSupportedFormats(H.Format ... fmts) {
        supportedFormats.addAll((Collection<H.Format>)C.listOf((Object[])fmts));
    }

    public static void registerSupportedFormats(Collection<H.Format> fmts) {
        supportedFormats.addAll(fmts);
    }

    public static boolean isAcceptFormatSupported(H.Format fmt) {
        return H.Format.UNKNOWN == fmt || H.Format.HTML == fmt || H.Format.JSON == fmt || H.Format.XML == fmt || H.Format.TXT == fmt || H.Format.CSV == fmt || supportedFormats.contains(fmt);
    }
}

