/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Destroyable;
import act.app.App;
import act.conf.AppConfig;
import act.util.ActContext;
import act.util.DestroyableBase;
import act.view.ActionViewVarDef;
import act.view.ImplicitVariableProvider;
import act.view.MailerViewVarDef;
import act.view.Template;
import act.view.TemplatePathResolver;
import act.view.View;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Osgl;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class ViewManager
extends DestroyableBase {
    private C.List<View> viewList = C.newList();
    private C.List<ActionViewVarDef> implicitActionViewVariables = C.newList();
    private C.List<MailerViewVarDef> implicitMailerViewVariables = C.newList();
    private Map<String, View> preferredViews = new HashMap<String, View>();
    private boolean multiViews = false;

    void register(View view) {
        E.NPE((Object)view);
        if (this.registered(view)) {
            throw new UnexpectedException("View[%s] already registered", new Object[]{view.name()});
        }
        this.viewList.add((Object)view);
    }

    void register(ImplicitVariableProvider implicitVariableProvider) {
        E.NPE((Object)implicitVariableProvider);
        List<ActionViewVarDef> l0 = implicitVariableProvider.implicitActionViewVariables();
        for (ActionViewVarDef var : l0) {
            if (this.implicitActionViewVariables.contains((Object)var)) {
                throw new UnexpectedException("Implicit variable[%s] has already been registered", new Object[]{var.name()});
            }
            this.implicitActionViewVariables.add((Object)var);
        }
        List<MailerViewVarDef> l1 = implicitVariableProvider.implicitMailerViewVariables();
        for (MailerViewVarDef var : l1) {
            if (this.implicitMailerViewVariables.contains((Object)var)) {
                throw new UnexpectedException("Implicit variable[%s] has already been registered", new Object[]{var.name()});
            }
            this.implicitMailerViewVariables.add((Object)var);
        }
    }

    public void onAppStart() {
        int viewCount = this.viewList.size();
        this.multiViews = viewCount > 1;
    }

    public void reload(App app) {
        for (View view : this.viewList) {
            view.reload(app);
        }
    }

    public View view(String name) {
        Osgl.Option<View> viewBag = this.findViewByName(name);
        return viewBag.isDefined() ? (View)viewBag.get() : null;
    }

    public Template load(ActContext context) {
        String amendedPath;
        AppConfig config = context.config();
        Template cached = context.cachedTemplate();
        if (null != cached) {
            return cached;
        }
        TemplatePathResolver resolver = config.templatePathResolver();
        String path = resolver.resolve(context);
        Template template = this.getTemplate(context, config, path);
        if (null == template && S.neq((String)(amendedPath = resolver.resolveWithContextMethodPath(context)), (String)path) && null != (template = this.getTemplate(context, config, amendedPath))) {
            context.templatePath(amendedPath);
        }
        return template;
    }

    private Template getTemplate(ActContext context, AppConfig config, String path) {
        View preferred;
        String templatePath = S.ensureStartsWith((String)path, (char)'/');
        Template template = null;
        if (this.multiViews && null != (preferred = this.preferredViews.get(templatePath)) && preferred.appliedTo(context) && null != (template = preferred.loadTemplate(templatePath, context))) {
            context.cacheTemplate(template);
            return template;
        }
        View defView = config.defaultView();
        if (null != defView && defView.appliedTo(context)) {
            template = defView.loadTemplate(templatePath, context);
        }
        if (null == template && this.multiViews) {
            for (View view : this.viewList) {
                if (view == defView || !view.appliedTo(context) || null == (template = view.loadTemplate(templatePath, context))) continue;
                if (this.multiViews) {
                    this.preferredViews.put(templatePath, view);
                }
                break;
            }
        } else if (this.multiViews) {
            this.preferredViews.put(templatePath, defView);
        }
        if (null != template) {
            context.cacheTemplate(template);
        }
        return template;
    }

    public List<ActionViewVarDef> implicitActionViewVariables() {
        return C.list(this.implicitActionViewVariables);
    }

    public List<MailerViewVarDef> implicitMailerViewVariables() {
        return C.list(this.implicitMailerViewVariables);
    }

    public void reset() {
        this.viewList.clear();
        this.preferredViews.clear();
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.viewList, ApplicationScoped.class);
        this.viewList = null;
        this.implicitActionViewVariables.clear();
        this.implicitActionViewVariables = null;
        this.implicitMailerViewVariables.clear();
        this.implicitMailerViewVariables = null;
        this.preferredViews.clear();
        this.preferredViews = null;
    }

    private boolean registered(View view) {
        String name = view.name().toUpperCase();
        return this.findViewByName(name).isDefined();
    }

    private Osgl.Option<View> findViewByName(final String name) {
        return this.viewList.findFirst((Osgl.Function)new Osgl.Predicate<View>(){

            public boolean test(View view) {
                return view.name().toUpperCase().equals(name.toUpperCase());
            }
        });
    }
}

