/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.app.ActionContext;
import act.mail.MailerContext;
import act.view.TemplateBase;
import java.util.Locale;
import java.util.Map;
import org.osgl.util.E;
import org.rythmengine.RythmEngine;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.template.ITemplate;

public class RythmTemplate
extends TemplateBase {
    private RythmEngine engine;
    private String path;

    public RythmTemplate(RythmEngine engine, String path) {
        E.NPE((Object)engine);
        this.engine = engine;
        this.path = path;
    }

    @Override
    protected void beforeRender(ActionContext context) {
        Locale locale = context.locale();
        this.engine = this.engine.prepare(locale);
    }

    @Override
    protected void beforeRender(MailerContext context) {
        Locale locale = context.locale();
        this.engine = this.engine.prepare(locale);
    }

    @Override
    protected String render(Map<String, Object> renderArgs) {
        ITemplate t = this.template(renderArgs);
        return t.render();
    }

    private ITemplate template(Map<String, Object> renderArgs) {
        return this.engine.getTemplate(this.path, new Object[]{renderArgs});
    }

    public static RythmTemplate find(RythmEngine engine, String path) {
        ITemplateResource resource = engine.resourceManager().getResource(path);
        if (!resource.isValid()) {
            return null;
        }
        return new RythmTemplate(engine, path);
    }
}

