/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.Act;
import act.app.App;
import act.conf.AppConfig;
import act.util.ActContext;
import act.view.Template;
import act.view.VarDef;
import act.view.View;
import act.view.rythm.RythmTemplate;
import act.view.rythm.Tags;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.util.C;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IFormatter;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.resource.ClasspathResourceLoader;
import org.rythmengine.template.ITemplate;

public class RythmView
extends View {
    public static final String ID = "rythm";
    ConcurrentMap<App, RythmEngine> engines = new ConcurrentHashMap<App, RythmEngine>();
    ConcurrentMap<String, Template> templates = new ConcurrentHashMap<String, Template>();
    ConcurrentMap<String, String> missings = new ConcurrentHashMap<String, String>();
    private boolean isDev = Act.isDev();

    @Override
    public String name() {
        return ID;
    }

    @Override
    protected Template loadTemplate(String resourcePath, ActContext context) {
        if (this.isDev) {
            return this.loadTemplateFromResource(resourcePath, context.app());
        }
        if (this.missings.containsKey(resourcePath)) {
            return null;
        }
        Template template = (Template)this.templates.get(resourcePath);
        if (null == template) {
            template = this.loadTemplateFromResource(resourcePath, context.app());
            if (null != template) {
                this.templates.putIfAbsent(resourcePath, template);
            } else {
                this.missings.put(resourcePath, resourcePath);
            }
        }
        return template;
    }

    public RythmEngine getEngine(App app) {
        RythmEngine engine0;
        RythmEngine engine = (RythmEngine)this.engines.get(app);
        if (null == engine && null != (engine0 = this.engines.putIfAbsent(app, engine = this.createEngine(app)))) {
            engine.shutdown();
            engine = engine0;
        }
        return engine;
    }

    private Template loadTemplateFromResource(String resourcePath, App app) {
        RythmEngine engine = this.getEngine(app);
        return RythmTemplate.find(engine, resourcePath);
    }

    private RythmEngine createEngine(App app) {
        AppConfig<?> config = app.config();
        Properties p = new Properties();
        p.put(RythmConfigurationKey.ENGINE_MODE.getKey(), Act.mode().isDev() ? Rythm.Mode.dev : Rythm.Mode.prod);
        p.put(RythmConfigurationKey.ENGINE_PLUGIN_VERSION.getKey(), Act.VERSION);
        p.put(RythmConfigurationKey.ENGINE_CLASS_LOADER_PARENT_IMPL.getKey(), app.classLoader());
        p.put(RythmConfigurationKey.HOME_TMP.getKey(), this.createTempHome(app));
        Map map = config.rawConfiguration();
        for (Object k : map.keySet()) {
            String key = k.toString();
            if (!key.startsWith("rythm.")) continue;
            p.put(key, map.get(key));
        }
        String appRestricted = p.getProperty("rythm.sandbox.restricted_classes", "");
        appRestricted = appRestricted + ";act.*";
        p.put(RythmConfigurationKey.SANDBOX_RESTRICTED_CLASS.getKey(), appRestricted);
        p.put(RythmConfigurationKey.HOME_TEMPLATE.getKey(), this.templateRootDir());
        p.put(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER.getKey(), new ISourceCodeEnhancer(){

            public List<String> imports() {
                return C.list();
            }

            public String sourceCode() {
                return "";
            }

            public Map<String, ?> getRenderArgDescriptions() {
                C.Map map = C.newMap((Object[])new Object[0]);
                for (VarDef varDef : Act.viewManager().implicitActionViewVariables()) {
                    map.put(varDef.name(), varDef.type());
                }
                return map;
            }

            public void setRenderArgs(ITemplate iTemplate) {
            }
        });
        RythmEngine engine = new RythmEngine(p);
        engine.resourceManager().addResourceLoader((ITemplateResourceLoader)new ClasspathResourceLoader(engine, ID));
        Tags tags = app.getInstance(Tags.class);
        tags.register(engine);
        return engine;
    }

    public void registerTransformer(App app, Class<?> clazz) {
        this.getEngine(app).registerTransformer(new Class[]{clazz});
    }

    public void registerBuiltInTransformer(App app, Class<?> clazz) {
        this.getEngine(app).registerTransformer(ID, "([^a-zA-Z0-9_]s\\(\\)|^s\\(\\))", new Class[]{clazz});
    }

    public void registerFormatter(App app, IFormatter formatter) {
        this.getEngine(app).extensionManager().registerFormatter(formatter);
    }

    @Override
    protected void reload(App app) {
        this.engines.remove(app);
        super.reload(app);
    }

    private File createTempHome(App app) {
        String tmp = System.getProperty("java.io.tmpdir");
        File f2 = new File(tmp, "__rythm_" + app.name());
        if (!f2.exists() && !f2.mkdirs()) {
            f2 = new File(tmp);
        }
        return f2;
    }
}

