/*
 * Decompiled with CFR 0.152.
 */
package act.xio;

import act.Act;
import act.Destroyable;
import act.util.DestroyableBase;
import act.xio.Network;
import act.xio.NetworkHandler;
import java.io.IOException;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;

public abstract class NetworkBase
extends DestroyableBase
implements Network {
    protected static final Logger logger = LogManager.get(Network.class);
    private volatile boolean started;
    private Map<Integer, NetworkHandler> registry = C.newMap((Object[])new Object[0]);
    private Map<Integer, NetworkHandler> failed = C.newMap((Object[])new Object[0]);

    @Override
    public synchronized void register(int port, NetworkHandler client) {
        E.NPE((Object)client);
        E.illegalArgumentIf((boolean)this.registry.containsKey(port), (String)"Port %s has been registered already", (Object[])new Object[]{port});
        this.registry.put(port, client);
        if (this.started) {
            if (!this.trySetUpClient(client, port)) {
                this.failed.put(port, client);
            } else {
                logger.info("network client hooked on port: %s", new Object[]{port});
            }
        }
    }

    @Override
    public void start() {
        this.bootUp();
        for (int port : this.registry.keySet()) {
            NetworkHandler client = this.registry.get(port);
            if (!this.trySetUpClient(client, port)) {
                this.failed.put(port, client);
                continue;
            }
            Act.LOGGER.info("network client hooked on port: %s", new Object[]{port});
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        this.close();
    }

    private boolean trySetUpClient(NetworkHandler client, int port) {
        try {
            this.setUpClient(client, port);
            return true;
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "Cannot set up %s to port %s:", new Object[]{client, port});
            return false;
        }
    }

    protected abstract void setUpClient(NetworkHandler var1, int var2) throws IOException;

    protected abstract void bootUp();

    protected abstract void close();

    @Override
    protected void releaseResources() {
        super.releaseResources();
        Destroyable.Util.destroyAll(this.registry.values(), ApplicationScoped.class);
        this.registry.clear();
    }
}

