/*
 * Decompiled with CFR 0.152.
 */
package act.xio;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.util.NamedPort;
import act.handler.RequestHandler;
import act.handler.builtin.controller.FastRequestHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.metric.Metric;
import act.metric.Timer;
import act.route.Router;
import act.util.DestroyableBase;
import act.view.ActErrorResult;
import act.xio.NetworkDispatcher;
import act.xio.NetworkJob;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.S;

public class NetworkHandler
extends DestroyableBase {
    private static Logger logger = LogManager.get(NetworkHandler.class);
    private final App app;
    private NamedPort port;
    private Metric metric;
    private Osgl.Func2<H.Request, String, String> contentSuffixProcessor;
    private static Osgl.Func2<H.Request, String, String> DUMB_CONTENT_SUFFIX_SENSOR = new Osgl.Func2<H.Request, String, String>(){

        public String apply(H.Request request, String s) throws NotAppliedException, Osgl.Break {
            return s;
        }
    };

    public NetworkHandler(App app) {
        E.NPE((Object)app);
        this.app = app;
        this.metric = Act.metricPlugin().metric("act.http");
        this.contentSuffixProcessor = app.config().contentSuffixAware() != false ? new ContentSuffixSensor() : DUMB_CONTENT_SUFFIX_SENSOR;
    }

    public NetworkHandler(App app, NamedPort port) {
        this(app);
        this.port = port;
    }

    public App app() {
        return this.app;
    }

    public void handle(final ActionContext ctx, NetworkDispatcher dispatcher) {
        if (this.isDestroyed()) {
            return;
        }
        final H.Request req = ctx.req();
        String url = req.url();
        H.Method method = req.method();
        if (Act.isDev() && !url.startsWith("/asset/")) {
            this.app.checkUpdates(false);
        }
        url = (String)this.contentSuffixProcessor.apply((Object)req, (Object)url);
        Timer timer = this.metric.startTimer("act:routing");
        final RequestHandler requestHandler = this.router().getInvoker(method, url, ctx);
        ctx.handler(requestHandler);
        timer.stop();
        NetworkJob job = new NetworkJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String key = S.concat((String)"act:http", (String)":", (String)requestHandler.toString());
                Timer timer = NetworkHandler.this.metric.startTimer(key);
                ctx.saveLocal();
                try {
                    requestHandler.handle(ctx);
                }
                catch (Result r) {
                    H.Format fmt;
                    try {
                        r = RequestHandlerProxy.GLOBAL_AFTER_INTERCEPTOR.apply(r, ctx);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e, "Error calling global after interceptor");
                        r = ActErrorResult.of(e);
                    }
                    if (null == ctx.handler()) {
                        ctx.handler(FastRequestHandler.DUMB);
                    }
                    if (H.Format.UNKNOWN == (fmt = req.accept())) {
                        fmt = req.contentType();
                    }
                    ctx.resp().addHeaderIfNotAdded("Content-Type", fmt.contentType());
                    r.apply(req, ctx.resp());
                }
                catch (Exception t) {
                    Result r;
                    logger.error((Throwable)t, "Error handling network request");
                    try {
                        r = RequestHandlerProxy.GLOBAL_EXCEPTION_INTERCEPTOR.apply(t, ctx);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e, "Error calling global exception interceptor");
                        r = ActErrorResult.of(e);
                    }
                    if (null == r) {
                        r = ActErrorResult.of(t);
                    } else if (r instanceof ErrorResult) {
                        r = ActErrorResult.of(r);
                    }
                    if (null == ctx.handler()) {
                        ctx.handler(FastRequestHandler.DUMB);
                    }
                    r.apply(req, ctx.resp());
                }
                finally {
                    ActionContext.clearCurrent();
                    if (null != timer) {
                        timer.stop();
                    }
                }
            }
        };
        if (method.unsafe() || !requestHandler.express(ctx)) {
            dispatcher.dispatch(job);
        } else {
            job.run();
        }
    }

    public String toString() {
        return this.app().name();
    }

    private Router router() {
        return this.app.router(this.port);
    }

    static class ContentSuffixSensor
    implements Osgl.Func2<H.Request, String, String> {
        private static final char[] mp3 = new char[]{'m', 'p'};
        private static final char[] mp4 = new char[]{'m', 'p'};
        private static final char[] mpa = new char[]{'m', 'p'};
        private static final char[] pdf = new char[]{'p'};
        private static final char[] gif = new char[0];
        private static final char[] tif = new char[0];
        private static final char[] png = new char[]{'p'};
        private static final char[] jpg = new char[0];
        private static final char[] mpg = new char[0];
        private static final char[] svg = new char[]{'s'};
        private static final char[] avi = new char[]{'a', 'v'};
        private static final char[] xml = new char[]{'x', 'm'};
        private static final char[] json = new char[]{'j', 's', 'o'};
        private static final char[] ico = new char[]{'i', 'c'};
        private static final char[] bmp = new char[]{'b', 'm'};
        private static final char[] xls = new char[]{'x', 'l'};
        private static final char[] wav = new char[]{'w'};
        private static final char[] flv = new char[]{'f'};
        private static final char[] csv = new char[]{'c'};
        private static final char[] mov = new char[]{'m'};
        private static final char[] xlsx = new char[]{'x', 'l', 's'};

        ContentSuffixSensor() {
        }

        public String apply(H.Request req, String url) throws NotAppliedException, Osgl.Break {
            Osgl.Var fmtBag = $.var();
            String processedUrl = ContentSuffixSensor.process(url, (Osgl.Var<H.Format>)fmtBag);
            H.Format fmt = (H.Format)fmtBag.get();
            if (null != fmt) {
                req.accept(fmt);
            }
            return processedUrl;
        }

        static String process(String url, Osgl.Var<H.Format> fmtBag) {
            char[] trait;
            int sz = url.length();
            if (sz < 4) {
                return url;
            }
            int start = sz - 1;
            char c = url.charAt(start);
            int initPos = 1;
            int sepPos = 3;
            H.Format fmt = H.Format.JSON;
            block0 : switch (c) {
                case '3': {
                    trait = mp3;
                    break;
                }
                case '4': {
                    trait = mp4;
                    break;
                }
                case 'a': {
                    trait = mpa;
                    break;
                }
                case 'f': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'd': {
                            trait = pdf;
                            fmt = H.Format.PDF;
                            break block0;
                        }
                        case 'i': {
                            c = url.charAt(start - 2);
                            initPos = 3;
                            switch (c) {
                                case 'g': {
                                    trait = gif;
                                    fmt = H.Format.GIF;
                                    break block0;
                                }
                                case 't': {
                                    trait = tif;
                                    fmt = H.Format.TIF;
                                    break block0;
                                }
                            }
                            return url;
                        }
                    }
                    return url;
                }
                case 'g': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'n': {
                            trait = png;
                            fmt = H.Format.PNG;
                            break block0;
                        }
                        case 'p': {
                            c = url.charAt(start - 2);
                            initPos = 3;
                            switch (c) {
                                case 'j': {
                                    trait = jpg;
                                    fmt = H.Format.JPG;
                                    break block0;
                                }
                                case 'm': {
                                    trait = mpg;
                                    fmt = H.Format.MPG;
                                    break block0;
                                }
                            }
                            return url;
                        }
                        case 'v': {
                            trait = svg;
                            fmt = H.Format.SVG;
                            break block0;
                        }
                    }
                    return url;
                }
                case 'i': {
                    trait = avi;
                    fmt = H.Format.AVI;
                    break;
                }
                case 'l': {
                    trait = xml;
                    fmt = H.Format.XML;
                    break;
                }
                case 'n': {
                    sepPos = 4;
                    trait = json;
                    break;
                }
                case 'o': {
                    trait = ico;
                    fmt = H.Format.ICO;
                    break;
                }
                case 'p': {
                    trait = bmp;
                    fmt = H.Format.BMP;
                    break;
                }
                case 's': {
                    trait = xls;
                    fmt = H.Format.XLS;
                    break;
                }
                case 'v': {
                    c = url.charAt(start - 1);
                    initPos = 2;
                    switch (c) {
                        case 'a': {
                            trait = wav;
                            fmt = H.Format.WAV;
                            break block0;
                        }
                        case 'l': {
                            trait = flv;
                            fmt = H.Format.FLV;
                            break block0;
                        }
                        case 's': {
                            trait = csv;
                            fmt = H.Format.CSV;
                            break block0;
                        }
                        case 'o': {
                            trait = mov;
                            fmt = H.Format.MOV;
                            break block0;
                        }
                    }
                    return url;
                }
                case 'x': {
                    sepPos = 4;
                    trait = xlsx;
                    fmt = H.Format.XLSX;
                    break;
                }
                default: {
                    return url;
                }
            }
            char sep = url.charAt(start - sepPos);
            if (sep != '/') {
                return url;
            }
            for (int i = initPos; i < sepPos; ++i) {
                if (url.charAt(start - i) == trait[sepPos - i - 1]) continue;
                return url;
            }
            fmtBag.set((Object)fmt);
            return url.substring(0, sz - sepPos - 1);
        }
    }
}

