/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.app.ActionContext;
import act.xio.undertow.UndertowRequest;
import act.xio.undertow.UndertowResponse;
import io.undertow.io.BlockingReceiverImpl;
import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Receiver;
import io.undertow.io.Sender;
import io.undertow.io.UndertowInputStream;
import io.undertow.io.UndertowOutputStream;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.core.BlockingWriterSenderImpl;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgl.http.H;

public class ActBlockingExchange
implements BlockingHttpExchange {
    public static final AttachmentKey<ActionContext> KEY_APP_CTX = AttachmentKey.create(ActionContext.class);
    private InputStream inputStream;
    private OutputStream outputStream;
    private final HttpServerExchange exchange;

    public ActBlockingExchange(HttpServerExchange exchange, ActionContext context) {
        this.exchange = exchange;
        exchange.putAttachment(KEY_APP_CTX, (Object)context);
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new UndertowInputStream(this.exchange);
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new UndertowOutputStream(this.exchange);
        }
        return this.outputStream;
    }

    public Sender getSender() {
        H.Response response = this.ctx().resp();
        if (response.writerCreated()) {
            return new BlockingWriterSenderImpl(this.exchange, response.printWriter(), response.characterEncoding());
        }
        return new BlockingSenderImpl(this.exchange, response.outputStream());
    }

    public Receiver getReceiver() {
        return new BlockingReceiverImpl(this.exchange, this.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ActionContext ctx = this.ctx();
        if (!this.exchange.isComplete()) {
            try {
                UndertowRequest req = (UndertowRequest)ctx.req();
                req.closeAndDrainRequest();
            }
            finally {
                UndertowResponse resp = (UndertowResponse)ctx.resp();
                resp.closeStreamAndWriter();
            }
        }
        try {
            UndertowRequest req = (UndertowRequest)ctx.req();
            req.freeResources();
        }
        finally {
            UndertowResponse resp = (UndertowResponse)ctx.resp();
            resp.freeResources();
        }
    }

    private ActionContext ctx() {
        return (ActionContext)this.exchange.getAttachment(KEY_APP_CTX);
    }
}

