/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.xio.NetworkBase;
import act.xio.NetworkHandler;
import act.xio.undertow.ActHttpHandler;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class UndertowNetwork
extends NetworkBase {
    private static final Logger logger = L.get(UndertowNetwork.class);
    private Xnio xnio;
    private int ioThreads;
    private XnioWorker worker;
    private int buffersPerRegion;
    private Pool<ByteBuffer> buffers;
    private boolean directBuffers;
    private OptionMap socketOptions;
    private OptionMap undertowOptions;
    private List<AcceptingChannel<? extends StreamConnection>> channels;

    @Override
    protected void bootUp() {
        try {
            this.xnio = Xnio.getInstance();
            this.worker = this.createWorker();
            this.buffers = this.createBuffer();
            this.socketOptions = this.createSocketOptions();
            this.undertowOptions = OptionMap.builder().set(UndertowOptions.BUFFER_PIPELINED_DATA, true).getMap();
            this.channels = C.newList();
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e, (String)"Error booting up Undertow service: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void setUpClient(NetworkHandler client, int port) throws IOException {
        ActHttpHandler handler = new ActHttpHandler(client);
        HttpOpenListener openListener = new HttpOpenListener(this.buffers, this.undertowOptions);
        openListener.setRootHandler((HttpHandler)handler);
        ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
        AcceptingChannel server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(port), acceptListener, this.socketOptions);
        server.resumeAccepts();
        this.channels.add((AcceptingChannel<? extends StreamConnection>)server);
    }

    @Override
    protected void close() {
        if (null == this.channels) {
            return;
        }
        for (AcceptingChannel<? extends StreamConnection> channel : this.channels) {
            IO.close(channel);
        }
        this.channels.clear();
        this.worker.shutdownNow();
    }

    private XnioWorker createWorker() throws IOException {
        this.ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        int workerThreads = this.ioThreads * 8;
        return this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.WORKER_TASK_CORE_THREADS, workerThreads).set(Options.WORKER_TASK_MAX_THREADS, workerThreads).set(Options.TCP_NODELAY, true).getMap());
    }

    private Pool<ByteBuffer> createBuffer() {
        int bufferSize;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            this.directBuffers = false;
            bufferSize = 512;
            this.buffersPerRegion = 10;
        } else if (maxMemory < 0x8000000L) {
            this.directBuffers = true;
            bufferSize = 1024;
            this.buffersPerRegion = 10;
        } else {
            this.directBuffers = true;
            bufferSize = 16384;
            this.buffersPerRegion = 20;
        }
        return new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, bufferSize, bufferSize * this.buffersPerRegion);
    }

    private OptionMap createSocketOptions() {
        OptionMap socketOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
        return socketOptions;
    }
}

