/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.RequestImplBase;
import act.app.ActionContext;
import act.conf.AppConfig;
import act.xio.undertow.ActBlockingExchange;
import act.xio.undertow.CookieConverter;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.Map;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.IO;

public class UndertowRequest
extends RequestImplBase<UndertowRequest> {
    private HttpServerExchange hse;
    private Map<String, Deque<String>> queryParams;

    protected Class<UndertowRequest> _impl() {
        return UndertowRequest.class;
    }

    public UndertowRequest(HttpServerExchange exchange, AppConfig config) {
        super(config);
        E.NPE((Object)exchange);
        this.hse = exchange;
    }

    public String path() {
        return this.hse.getRequestPath();
    }

    public String query() {
        return this.hse.getQueryString();
    }

    @Override
    protected H.Method _method() {
        return H.Method.valueOfIgnoreCase((String)this.hse.getRequestMethod().toString());
    }

    public String header(String name) {
        return this.hse.getRequestHeaders().get(name, 0);
    }

    public Iterable<String> headers(String name) {
        return this.hse.getRequestHeaders().eachValue(HttpString.tryFromString((String)name));
    }

    public InputStream createInputStream() throws IllegalStateException {
        if (!this.hse.isBlocking()) {
            this.hse.startBlocking((BlockingHttpExchange)new ActBlockingExchange(this.hse, ActionContext.current()));
        }
        return this.hse.getInputStream();
    }

    public String paramVal(String name) {
        Deque<String> dq;
        if (null == this.queryParams) {
            this.queryParams = this.hse.getQueryParameters();
        }
        return null == (dq = this.queryParams.get(name)) ? null : dq.peekFirst();
    }

    public String[] paramVals(String name) {
        Deque<String> deque;
        if (null == this.queryParams) {
            this.queryParams = this.hse.getQueryParameters();
        }
        if (null == (deque = this.queryParams.get(name))) {
            return null;
        }
        String[] sa = new String[deque.size()];
        sa = deque.toArray(sa);
        return sa;
    }

    public Iterable<String> paramNames() {
        if (null == this.queryParams) {
            this.queryParams = this.hse.getQueryParameters();
        }
        return this.queryParams.keySet();
    }

    public void closeAndDrainRequest() {
        if (null != this.reader) {
            IO.close((Closeable)this.reader);
        } else {
            IO.close((Closeable)this.inputStream());
        }
    }

    public void freeResources() {
        if (this.reader != null) {
            IO.close((Closeable)this.reader);
        } else if (this.inputStream != null) {
            IO.close((Closeable)this.inputStream);
        }
    }

    protected String _ip() {
        InetSocketAddress sourceAddress = this.hse.getSourceAddress();
        if (sourceAddress == null) {
            return "";
        }
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            return sourceAddress.getHostString();
        }
        return address.getHostAddress();
    }

    protected void _initCookieMap() {
        Map cookies = this.hse.getRequestCookies();
        if (cookies.isEmpty()) {
            return;
        }
        for (Map.Entry entry : cookies.entrySet()) {
            Cookie cookie = (Cookie)entry.getValue();
            try {
                this._setCookie(cookie.getName(), CookieConverter.undertow2osgl(cookie));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

