/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.ResponseImplBase;
import act.app.ActionContext;
import act.conf.AppConfig;
import act.xio.undertow.ActBlockingExchange;
import act.xio.undertow.CookieConverter;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.IO;

public class UndertowResponse
extends ResponseImplBase<UndertowResponse> {
    private HttpServerExchange hse;

    protected Class<UndertowResponse> _impl() {
        return UndertowResponse.class;
    }

    public UndertowResponse(HttpServerExchange exchange, AppConfig config) {
        super(config);
        E.NPE((Object)exchange);
        this.hse = exchange;
        this.header("Server", config.serverHeader());
    }

    public void addCookie(H.Cookie cookie) {
        this.hse.setResponseCookie(CookieConverter.osgl2undertow(cookie));
    }

    public boolean containsHeader(String name) {
        return this.hse.getResponseHeaders().contains(name);
    }

    @Override
    public UndertowResponse characterEncoding(String encoding) {
        this.hse.getResponseHeaders().put(HttpString.tryFromString((String)"Accept-Charset"), encoding);
        return this;
    }

    public UndertowResponse contentLength(long len) {
        this.hse.setResponseContentLength(len);
        return this;
    }

    public UndertowResponse writeContent(String s) {
        this.hse.getResponseSender().send(s);
        return this;
    }

    public UndertowResponse writeContent(ByteBuffer byteBuffer) {
        this.hse.getResponseSender().send(byteBuffer);
        return this;
    }

    protected OutputStream createOutputStream() {
        this.ensureBlocking();
        return this.hse.getOutputStream();
    }

    protected void _setContentType(String type) {
        this.hse.getResponseHeaders().put(HttpString.tryFromString((String)"Content-Type"), type);
    }

    public OutputStream outputStream() throws IllegalStateException, UnexpectedIOException {
        return super.outputStream();
    }

    protected void _setLocale(Locale loc) {
        if (this.responseStarted()) {
            return;
        }
        this.locale = loc;
        this.hse.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, loc.getLanguage() + "-" + loc.getCountry());
    }

    public Locale locale() {
        return this.locale;
    }

    public void commit() {
        this.hse.endExchange();
    }

    public UndertowResponse sendError(int sc, String msg) {
        return null;
    }

    public UndertowResponse sendError(int sc) {
        return null;
    }

    public UndertowResponse sendRedirect(String location) {
        return null;
    }

    public UndertowResponse header(String name, String value) {
        this.hse.getResponseHeaders().put(new HttpString(name), value);
        return this;
    }

    public UndertowResponse status(int sc) {
        this.hse.setStatusCode(sc);
        return this;
    }

    public UndertowResponse addHeader(String name, String value) {
        HeaderMap map = this.hse.getResponseHeaders();
        map.add(HttpString.tryFromString((String)name), value);
        return this;
    }

    public void closeStreamAndWriter() {
        if (this.writer != null) {
            IO.close((Closeable)this.writer);
        } else {
            IO.close((Closeable)this.outputStream());
        }
    }

    public void freeResources() {
        if (this.writer != null) {
            IO.close((Closeable)this.writer);
        } else if (this.outputStream != null) {
            IO.close((Closeable)this.outputStream);
        }
    }

    private void ensureBlocking() {
        if (!this.hse.isBlocking()) {
            this.hse.startBlocking((BlockingHttpExchange)new ActBlockingExchange(this.hse, ActionContext.current()));
        }
    }

    private boolean responseStarted() {
        return this.hse.isResponseStarted();
    }
}

