package act.db.util;

/*-
 * #%L
 * ACT Framework
 * %%
 * Copyright (C) 2014 - 2017 ActFramework
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import act.db.DB;

import java.io.Serializable;
import java.lang.annotation.Annotation;

// Follow the implementation of com.google.inject.name.NamedImpl
public class DBAnnotation implements DB, Serializable {

    private String db;

    public DBAnnotation(String db) {
        this.db = db;
    }

    @Override
    public String value() {
        return db;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return DB.class;
    }

    @Override
    public int hashCode() {
        // This is specified in java.lang.Annotation.
        return (127 * "value".hashCode()) ^ db.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DB)) {
            return false;
        }

        DB other = (DB) o;
        return db.equals(other.value());
    }

    @Override
    public String toString() {
        return "@" + DB.class.getName() + "(value=" + db + ")";
    }

    private static final long serialVersionUID = 0;
}
