package act.data.annotation;

/*-
 * #%L
 * ACT Framework
 * %%
 * Copyright (C) 2014 - 2017 ActFramework
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import act.util.EqualField;
import act.util.EqualIgnore;

import java.lang.annotation.*;

/**
 * Mark a class eligible to auto generation on {@link Object#equals(Object)}
 * and {@link Object#hashCode()}.
 * <p>By default all fields will be used when generating the methods except</p>
 * <ul>
 *     <li>static fields are not considered</li>
 *     <li>transient fields are not considered unless {@link EqualField} annotation
 *     found on the field</li>
 *     <li>fields with {@link EqualIgnore} annotation presented</li>
 * </ul>
 * <p>If the {@link Object#equals(Object)} method found in the class, then the method
 * will not be generated</p>
 * <p>If the {@link Object#hashCode()} method found in the class, then the metheod
 * will not be generated</p>
 */
@Retention(RetentionPolicy.CLASS)
@Target(ElementType.TYPE)
@Documented
public @interface Data {
    /**
     * Whether the generated {@code equals} and {@code hashCode}
     * method should call super methods.
     * <p>If not specified, then super method will not be called</p>
     * @return {@code true} if super should be called in autogenerated
     *         methods
     */
    boolean callSuper() default false;
}
